/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.lang.dart.ide.runner.DartExecutionHelper;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import io.flutter.FlutterInitializer;
import io.flutter.actions.RestartFlutterApp;
import io.flutter.dart.DartPlugin;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogView;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.MainFile;
import io.flutter.run.OpenObservatoryAction;
import io.flutter.run.OpenTimelineViewAction;
import io.flutter.run.PositionMapper;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import io.flutter.run.bazel.BazelRunConfig;
import io.flutter.run.daemon.DaemonConsoleView;
import io.flutter.run.daemon.DeviceService;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.run.daemon.RunMode;
import io.flutter.server.vmService.DartVmServiceDebugProcess;
import io.flutter.view.OpenFlutterViewAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchState
extends CommandLineState {
    public static final String ANDROID_PROFILER_EXECUTOR_ID = "Android Profiler";
    @NotNull
    private final VirtualFile workDir;
    @NotNull
    private final VirtualFile sourceLocation;
    @NotNull
    private final RunConfig runConfig;
    @NotNull
    private final Callback callback;
    private static final Key<RunConfig> FLUTTER_RUN_CONFIG_KEY = new Key("FLUTTER_RUN_CONFIG_KEY");
    private static final Logger LOG = Logger.getInstance(LaunchState.class);

    public LaunchState(@NotNull ExecutionEnvironment env, @NotNull VirtualFile workDir, @NotNull VirtualFile sourceLocation, @NotNull RunConfig runConfig, @NotNull Callback callback) {
        if (env == null) {
            LaunchState.$$$reportNull$$$0(0);
        }
        if (workDir == null) {
            LaunchState.$$$reportNull$$$0(1);
        }
        if (sourceLocation == null) {
            LaunchState.$$$reportNull$$$0(2);
        }
        if (runConfig == null) {
            LaunchState.$$$reportNull$$$0(3);
        }
        if (callback == null) {
            LaunchState.$$$reportNull$$$0(4);
        }
        super(env);
        this.workDir = workDir;
        this.sourceLocation = sourceLocation;
        this.runConfig = runConfig;
        this.callback = callback;
        DaemonConsoleView.install(this, env, workDir);
    }

    @Nullable
    protected ConsoleView createConsole(@NotNull Executor executor) throws com.intellij.execution.ExecutionException {
        if (executor == null) {
            LaunchState.$$$reportNull$$$0(5);
        }
        if (FlutterLog.isLoggingEnabled()) {
            FlutterApp app = FlutterApp.fromEnv(this.getEnvironment());
            assert (app != null);
            return new FlutterLogView(app);
        }
        return super.createConsole(executor);
    }

    private RunContentDescriptor launch(@NotNull ExecutionEnvironment env) throws com.intellij.execution.ExecutionException {
        FlutterLaunchMode launchMode;
        Class dartExecutionHelper;
        String commandLineString;
        if (env == null) {
            LaunchState.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        if (RunMode.fromEnv(env).isProfiling()) {
            FlutterLaunchMode.addToEnvironment(env, FlutterLaunchMode.PROFILE);
        }
        Project project = this.getEnvironment().getProject();
        FlutterDevice device = DeviceService.getInstance(project).getSelectedDevice();
        FlutterApp app = this.callback.createApp(device);
        if (device == null) {
            Messages.showDialog((Project)project, (String)"No connected devices found; please connect a device, or see flutter.io/setup for getting started instructions.", (String)"No Connected Devices Found", (String[])new String[]{Messages.OK_BUTTON}, (int)0, (Icon)AllIcons.General.InformationDialog);
            return null;
        }
        FlutterApp.addToEnvironment(env, app);
        app.getProcessHandler().putUserData(FLUTTER_RUN_CONFIG_KEY, (Object)this.runConfig);
        ExecutionResult result = this.setUpConsoleAndActions(app);
        if (this.runConfig instanceof BazelRunConfig && app.getConsole() != null && app.getProcessHandler() instanceof OSProcessHandler && StringUtil.isNotEmpty((String)(commandLineString = ((OSProcessHandler)app.getProcessHandler()).getCommandLine().trim()))) {
            app.getConsole().print(commandLineString + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        device.bringToFront();
        if (env.getRunProfile() instanceof SdkRunConfig && (dartExecutionHelper = LaunchState.classForName("com.jetbrains.lang.dart.ide.runner.DartExecutionHelper")) != null) {
            String message = "<a href='open.dart.analysis'>Analysis issues</a> may affect the execution of '" + env.getRunProfile().getName() + "'.";
            SdkRunConfig config = (SdkRunConfig)env.getRunProfile();
            SdkFields sdkFields = config.getFields();
            MainFile mainFile = MainFile.verify(sdkFields.getFilePath(), env.getProject()).get();
            DartExecutionHelper.displayIssues((Project)project, (VirtualFile)mainFile.getFile(), (String)message, (Icon)env.getRunProfile().getIcon());
        }
        if ((launchMode = FlutterLaunchMode.fromEnv(env)).supportsDebugConnection()) {
            return this.createDebugSession(env, app, result).getRunContentDescriptor();
        }
        return new RunContentBuilder(result, env).showRunContent(env.getContentToReuse());
    }

    private static Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @NotNull
    private XDebugSession createDebugSession(final @NotNull ExecutionEnvironment env, final @NotNull FlutterApp app, final @NotNull ExecutionResult executionResult) throws com.intellij.execution.ExecutionException {
        if (env == null) {
            LaunchState.$$$reportNull$$$0(7);
        }
        if (app == null) {
            LaunchState.$$$reportNull$$$0(8);
        }
        if (executionResult == null) {
            LaunchState.$$$reportNull$$$0(9);
        }
        final DartUrlResolver resolver = DartUrlResolver.getInstance((Project)env.getProject(), (VirtualFile)this.sourceLocation);
        final PositionMapper mapper = this.createPositionMapper(env, app, resolver);
        XDebuggerManager manager = XDebuggerManager.getInstance((Project)env.getProject());
        XDebugSession session = manager.startSession(env, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                if (session == null) {
                    1.$$$reportNull$$$0(0);
                }
                FlutterDebugProcess flutterDebugProcess = new FlutterDebugProcess(app, env, session, executionResult, resolver, (DartVmServiceDebugProcess.PositionMapper)mapper);
                if (flutterDebugProcess == null) {
                    1.$$$reportNull$$$0(1);
                }
                return flutterDebugProcess;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "session";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "io/flutter/run/LaunchState$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "io/flutter/run/LaunchState$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "start";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "start";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        if (app.getMode() != RunMode.DEBUG) {
            session.setBreakpointMuted(true);
        }
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            LaunchState.$$$reportNull$$$0(10);
        }
        return xDebugSession;
    }

    @NotNull
    private PositionMapper createPositionMapper(@NotNull ExecutionEnvironment env, @NotNull FlutterApp app, @NotNull DartUrlResolver resolver) {
        if (env == null) {
            LaunchState.$$$reportNull$$$0(11);
        }
        if (app == null) {
            LaunchState.$$$reportNull$$$0(12);
        }
        if (resolver == null) {
            LaunchState.$$$reportNull$$$0(13);
        }
        PositionMapper.Analyzer analyzer = app.getMode() == RunMode.DEBUG ? PositionMapper.Analyzer.create(env.getProject(), this.sourceLocation) : null;
        VirtualFile pubspec = resolver.getPubspecYamlFile();
        VirtualFile sourceRoot = pubspec != null ? pubspec.getParent() : this.workDir;
        PositionMapper positionMapper = new PositionMapper(env.getProject(), sourceRoot, resolver, analyzer);
        if (positionMapper == null) {
            LaunchState.$$$reportNull$$$0(14);
        }
        return positionMapper;
    }

    @NotNull
    private ExecutionResult setUpConsoleAndActions(@NotNull FlutterApp app) throws com.intellij.execution.ExecutionException {
        ConsoleView console;
        if (app == null) {
            LaunchState.$$$reportNull$$$0(15);
        }
        if ((console = this.createConsole(this.getEnvironment().getExecutor())) != null) {
            app.setConsole(console);
            console.attachToProcess(app.getProcessHandler());
        }
        Computable observatoryAvailable = () -> {
            if (app == null) {
                LaunchState.$$$reportNull$$$0(20);
            }
            return !app.getProcessHandler().isProcessTerminated() && app.getConnector().getBrowserUrl() != null;
        };
        ArrayList<AnAction> actions = new ArrayList<AnAction>(Arrays.asList(super.createActions(console, app.getProcessHandler(), this.getEnvironment().getExecutor())));
        actions.add((AnAction)new Separator());
        actions.add((AnAction)new OpenObservatoryAction(app.getConnector(), (Computable<Boolean>)observatoryAvailable));
        actions.add((AnAction)new OpenTimelineViewAction(app.getConnector(), (Computable<Boolean>)observatoryAvailable));
        actions.add((AnAction)new Separator());
        actions.add((AnAction)new OpenFlutterViewAction((Computable<Boolean>)((Computable)() -> {
            if (app == null) {
                LaunchState.$$$reportNull$$$0(19);
            }
            return !app.getProcessHandler().isProcessTerminated();
        })));
        DefaultExecutionResult defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)console, app.getProcessHandler(), actions.toArray(new AnAction[0]));
        if (defaultExecutionResult == null) {
            LaunchState.$$$reportNull$$$0(16);
        }
        return defaultExecutionResult;
    }

    @NotNull
    public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner runner) throws com.intellij.execution.ExecutionException {
        if (executor == null) {
            LaunchState.$$$reportNull$$$0(17);
        }
        if (runner == null) {
            LaunchState.$$$reportNull$$$0(18);
        }
        throw new com.intellij.execution.ExecutionException("not implemented");
    }

    @NotNull
    protected ProcessHandler startProcess() throws com.intellij.execution.ExecutionException {
        throw new com.intellij.execution.ExecutionException("need to implement LaunchState.Runner for " + this.runConfig.getClass());
    }

    @Nullable
    public static ProcessHandler getRunningAppProcess(RunConfig config) {
        Project project = config.getProject();
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || process.isProcessTerminated() || process.getUserData(FLUTTER_RUN_CONFIG_KEY) != config) continue;
            return process;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLocation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/LaunchState";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/LaunchState";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugSession";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createPositionMapper";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setUpConsoleAndActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "launch";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDebugSession";
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createPositionMapper";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setUpConsoleAndActions";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpConsoleAndActions$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUpConsoleAndActions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class Runner<C extends RunConfig>
    extends GenericProgramRunner {
        private final Class<C> runConfigClass;

        public Runner(Class<C> runConfigClass) {
            this.runConfigClass = runConfigClass;
        }

        public final boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
            if (executorId == null) {
                Runner.$$$reportNull$$$0(0);
            }
            if (profile == null) {
                Runner.$$$reportNull$$$0(1);
            }
            if (!(DefaultRunExecutor.EXECUTOR_ID.equals(executorId) || DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) || LaunchState.ANDROID_PROFILER_EXECUTOR_ID.equals(executorId))) {
                return false;
            }
            if (!(profile instanceof RunConfig)) {
                return false;
            }
            RunConfig config = (RunConfig)profile;
            ProcessHandler process = LaunchState.getRunningAppProcess(config);
            if (process != null) {
                FlutterApp app = FlutterApp.fromProcess(process);
                if (app == null) {
                    return false;
                }
                String selectedDeviceId = this.getSelectedDeviceId(config.getProject());
                if (StringUtil.equals((CharSequence)app.deviceId(), (CharSequence)selectedDeviceId)) {
                    if (!executorId.equals(app.getMode().mode())) {
                        return false;
                    }
                    if (app.getState() == FlutterApp.State.STARTING || app.getState() == FlutterApp.State.RELOADING || app.getState() == FlutterApp.State.RESTARTING) {
                        return false;
                    }
                }
            }
            if (DartPlugin.getDartSdk(config.getProject()) == null) {
                return false;
            }
            return this.runConfigClass.isInstance(profile) && this.canRun((RunConfig)this.runConfigClass.cast(profile));
        }

        protected boolean canRun(C config) {
            return true;
        }

        protected final RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws com.intellij.execution.ExecutionException {
            if (state == null) {
                Runner.$$$reportNull$$$0(2);
            }
            if (env == null) {
                Runner.$$$reportNull$$$0(3);
            }
            if (!(state instanceof LaunchState)) {
                LOG.error("unexpected RunProfileState: " + state.getClass());
                return null;
            }
            LaunchState launchState = (LaunchState)state;
            String executorId = env.getExecutor().getId();
            List runningProcesses = ExecutionManager.getInstance((Project)env.getProject()).getContentManager().getAllDescriptors();
            ProcessHandler process = LaunchState.getRunningAppProcess(launchState.runConfig);
            if (process != null) {
                FlutterApp app = FlutterApp.fromProcess(process);
                String selectedDeviceId = this.getSelectedDeviceId(env.getProject());
                if (app != null && StringUtil.equals((CharSequence)app.deviceId(), (CharSequence)selectedDeviceId)) {
                    if (executorId.equals(app.getMode().mode())) {
                        if (!Runner.identicalCommands(app.getCommand(), launchState.runConfig.getCommand(env, app.device()))) {
                            try {
                                app.shutdownAsync().get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                LOG.error((Throwable)e);
                            }
                            return launchState.launch(env);
                        }
                        FlutterLaunchMode launchMode = FlutterLaunchMode.fromEnv(env);
                        if (launchMode.supportsReload() && app.isStarted()) {
                            FileDocumentManager.getInstance().saveAllDocuments();
                            FlutterInitializer.sendAnalyticsAction(RestartFlutterApp.class.getSimpleName());
                            app.performRestartApp();
                        }
                    }
                    return null;
                }
            }
            return launchState.launch(env);
        }

        private static boolean identicalCommands(GeneralCommandLine a, GeneralCommandLine b) {
            return a.getParametersList().getList().equals(b.getParametersList().getList());
        }

        @Nullable
        private String getSelectedDeviceId(@NotNull Project project) {
            FlutterDevice selectedDevice;
            if (project == null) {
                Runner.$$$reportNull$$$0(4);
            }
            return (selectedDevice = DeviceService.getInstance(project).getSelectedDevice()) == null ? null : selectedDevice.deviceId();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executorId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "env";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/run/LaunchState$Runner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSelectedDeviceId";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface RunConfig
    extends RunProfile {
        public Project getProject();

        @NotNull
        public LaunchState getState(@NotNull Executor var1, @NotNull ExecutionEnvironment var2) throws com.intellij.execution.ExecutionException;

        @NotNull
        public GeneralCommandLine getCommand(ExecutionEnvironment var1, FlutterDevice var2) throws com.intellij.execution.ExecutionException;
    }

    public static interface Callback {
        public FlutterApp createApp(@Nullable FlutterDevice var1) throws com.intellij.execution.ExecutionException;
    }
}

