/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.view.FlutterViewMessages;
import org.jetbrains.annotations.NotNull;

public class FlutterRunNotifications {
    private static final String RELOAD_ALREADY_RUN = "io.flutter.reload.alreadyRun";
    @NotNull
    final Project myProject;

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterRunNotifications.$$$reportNull$$$0(0);
        }
        NotificationsConfiguration.getNotificationsConfiguration().register("Flutter Messages", NotificationDisplayType.BALLOON, false);
        FlutterRunNotifications notifications = new FlutterRunNotifications(project);
        project.getMessageBus().connect().subscribe(FlutterViewMessages.FLUTTER_DEBUG_TOPIC, event -> ApplicationManager.getApplication().invokeLater(notifications::checkForDisplayFirstReload));
    }

    FlutterRunNotifications(@NotNull Project project) {
        if (project == null) {
            FlutterRunNotifications.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    private void checkForDisplayFirstReload() {
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        boolean alreadyRun = properties.getBoolean(RELOAD_ALREADY_RUN);
        if (!alreadyRun) {
            properties.setValue(RELOAD_ALREADY_RUN, true);
            final Notification notification = new Notification("Flutter Messages", FlutterBundle.message("flutter.reload.firstRun.title", new Object[0]), FlutterBundle.message("flutter.reload.firstRun.content", new Object[0]), NotificationType.INFORMATION);
            notification.setIcon(FlutterIcons.HotReload);
            notification.addAction(new AnAction("Learn more"){

                public void actionPerformed(AnActionEvent event) {
                    BrowserUtil.browse((String)FlutterBundle.message("flutter.reload.firstRun.url", new Object[0]));
                    notification.expire();
                }
            });
            Notifications.Bus.notify((Notification)notification);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/run/FlutterRunNotifications";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

