/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.DartWritingAccessProvider;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartImportStatement;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.run.FlutterRunConfigurationType;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import java.util.Arrays;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterRunConfigurationProducer
extends RunConfigurationProducer<SdkRunConfig> {
    public FlutterRunConfigurationProducer() {
        super((ConfigurationType)FlutterRunConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(@NotNull SdkRunConfig config, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        VirtualFile main;
        if (config == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((main = FlutterRunConfigurationProducer.getFlutterEntryFile(context, true, true)) == null) {
            return false;
        }
        config.setFields(new SdkFields(main, context.getProject()));
        config.setGeneratedName();
        PsiElement elt = (PsiElement)sourceElement.get();
        if (elt != null) {
            sourceElement.set((Object)elt.getContainingFile());
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull SdkRunConfig configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return FlutterRunConfigurationProducer.hasDartFile(context, configuration.getFields().getFilePath());
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (other == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return DartPlugin.isDartRunConfiguration(other.getConfigurationType());
    }

    @Nullable
    public static VirtualFile getFlutterEntryFile(@NotNull ConfigurationContext context, boolean requireFlutterImport, boolean omitTests) {
        if (context == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        DartFile dart = FlutterRunConfigurationProducer.getDartFile(context);
        return FlutterRunConfigurationProducer.getFlutterEntryFile(dart, requireFlutterImport, omitTests);
    }

    @Nullable
    public static VirtualFile getFlutterEntryFile(@Nullable DartFile dart, boolean requireFlutterImport, boolean omitTests) {
        VirtualFile virtual;
        if (dart == null) {
            return null;
        }
        if (DartResolveUtil.getMainFunction((PsiFile)dart) == null) {
            return null;
        }
        if (requireFlutterImport && FlutterRunConfigurationProducer.findImportUrls(dart).noneMatch(url -> url.startsWith("package:flutter/"))) {
            return null;
        }
        if (omitTests) {
            if (FlutterRunConfigurationProducer.findImportUrls(dart).anyMatch(url -> url.startsWith("package:flutter_test/"))) {
                return null;
            }
            if (FlutterRunConfigurationProducer.findImportUrls(dart).anyMatch(url -> url.startsWith("package:test/"))) {
                return null;
            }
        }
        if ((virtual = DartResolveUtil.getRealVirtualFile((PsiFile)dart)) == null) {
            return null;
        }
        if (!ProjectRootManager.getInstance((Project)dart.getProject()).getFileIndex().isInContent(virtual)) {
            return null;
        }
        if (DartWritingAccessProvider.isInDartSdkOrDartPackagesFolder((Project)dart.getProject(), (VirtualFile)virtual)) {
            return null;
        }
        return virtual;
    }

    public static boolean hasDartFile(@NotNull ConfigurationContext context, String dartPath) {
        DartFile dart;
        if (context == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((dart = FlutterRunConfigurationProducer.getDartFile(context)) == null) {
            return false;
        }
        VirtualFile virtual = DartResolveUtil.getRealVirtualFile((PsiFile)dart);
        return virtual != null && virtual.getPath().equals(dartPath);
    }

    @Nullable
    public static DartFile getDartFile(@NotNull ConfigurationContext context) {
        if (context == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        return FlutterUtils.getDartFile(context.getPsiLocation());
    }

    @NotNull
    private static Stream<String> findImportUrls(@NotNull DartFile file) {
        DartImportStatement[] imports;
        if (file == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if ((imports = (DartImportStatement[])PsiTreeUtil.getChildrenOfType((PsiElement)file, DartImportStatement.class)) == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                FlutterRunConfigurationProducer.$$$reportNull$$$0(11);
            }
            return stream;
        }
        Stream<String> stream = Arrays.stream(imports).map(DartImportStatement::getUriString);
        if (stream == null) {
            FlutterRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/run/FlutterRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/run/FlutterRunConfigurationProducer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFlutterEntryFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasDartFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDartFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findImportUrls";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

