/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.run;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.EventStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterAppManager
implements Disposable {
    @NotNull
    private final Project project;
    private final EventStream<FlutterApp> activeAppSteam;
    private final ScheduledFuture task;
    private FlutterApp lastActiveApp;

    public static FlutterAppManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterAppManager.$$$reportNull$$$0(0);
        }
        return (FlutterAppManager)ServiceManager.getService((Project)project, FlutterAppManager.class);
    }

    private FlutterAppManager(@NotNull Project project) {
        if (project == null) {
            FlutterAppManager.$$$reportNull$$$0(1);
        }
        this.activeAppSteam = new EventStream();
        this.project = project;
        Disposer.register((Disposable)project, (Disposable)this);
        this.task = JobScheduler.getScheduler().scheduleWithFixedDelay(this::updateActiveApp, 1L, 1L, TimeUnit.SECONDS);
    }

    public void dispose() {
        this.task.cancel(false);
    }

    @Nullable
    public FlutterApp getActiveApp() {
        RunContentDescriptor descriptor = this.getRunContentManager().getSelectedContent();
        if (descriptor == null) {
            return null;
        }
        ProcessHandler process = descriptor.getProcessHandler();
        if (process == null) {
            return null;
        }
        FlutterApp app = FlutterApp.fromProcess(process);
        return app != null && app.isConnected() ? app : null;
    }

    public EventStream<FlutterApp> getActiveAppAsStream() {
        return this.activeAppSteam;
    }

    public List<FlutterApp> getApps() {
        ArrayList<FlutterApp> apps = new ArrayList<FlutterApp>();
        List runningProcesses = this.getRunContentManager().getAllDescriptors();
        for (RunContentDescriptor descriptor : runningProcesses) {
            FlutterApp app;
            ProcessHandler process = descriptor.getProcessHandler();
            if (process == null || (app = FlutterApp.fromProcess(process)) == null || !app.isConnected()) continue;
            apps.add(app);
        }
        return apps;
    }

    private void updateActiveApp() {
        FlutterApp activeApp = this.getActiveApp();
        if (activeApp != this.lastActiveApp) {
            this.lastActiveApp = activeApp;
            this.activeAppSteam.setValue(activeApp);
        }
    }

    private RunContentManager getRunContentManager() {
        return ExecutionManager.getInstance((Project)this.project).getContentManager();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/run/FlutterAppManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

