/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.pub;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoots;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PubRoot {
    private static final Logger LOG = Logger.getInstance(PubRoot.class);
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VirtualFile pubspec;
    @Nullable
    private final VirtualFile packagesFile;
    @Nullable
    private final VirtualFile lib;

    private PubRoot(@NotNull VirtualFile root, @NotNull VirtualFile pubspec, @Nullable VirtualFile packagesFile, @Nullable VirtualFile lib) {
        if (root == null) {
            PubRoot.$$$reportNull$$$0(0);
        }
        if (pubspec == null) {
            PubRoot.$$$reportNull$$$0(1);
        }
        assert (!root.getPath().endsWith("/"));
        this.root = root;
        this.pubspec = pubspec;
        this.packagesFile = packagesFile;
        this.lib = lib;
    }

    @Nullable
    public static PubRoot forFile(@Nullable VirtualFile file) {
        PubRoot root;
        if (file == null) {
            return null;
        }
        if (file.isDirectory() && (root = PubRoot.forDirectory(file.getParent())) != null) {
            return root;
        }
        return PubRoot.forFile(file.getParent());
    }

    @Nullable
    public static PubRoot forEventWithRefresh(@NotNull AnActionEvent event) {
        List<PubRoot> roots;
        List<PubRoot> roots2;
        PsiFile psiFile;
        if (event == null) {
            PubRoot.$$$reportNull$$$0(2);
        }
        if ((psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(event.getDataContext())) != null) {
            PubRoot root = PubRoot.forPsiFile(psiFile);
            return root == null ? null : root.refresh();
        }
        Module module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
        if (module != null && !(roots2 = PubRoots.forModule(module)).isEmpty()) {
            return roots2.get(0);
        }
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project != null && !(roots = PubRoots.forProject(project)).isEmpty()) {
            return roots.get(0);
        }
        return null;
    }

    @Nullable
    public static PubRoot forPsiFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            PubRoot.$$$reportNull$$$0(3);
        }
        if ((file = psiFile.getVirtualFile()) == null) {
            return null;
        }
        if (PubRoot.isPubspec(file)) {
            return PubRoot.forDirectory(file.getParent());
        }
        return PubRoot.forDescendant(file, psiFile.getProject());
    }

    @Nullable
    public static PubRoot forDescendant(VirtualFile fileOrDir, Project project) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile root = index.getContentRootForFile(fileOrDir);
        return PubRoot.forDirectory(root);
    }

    @Nullable
    public static PubRoot forDirectory(@Nullable VirtualFile dir) {
        VirtualFile lib;
        if (dir == null || !dir.isDirectory()) {
            return null;
        }
        VirtualFile pubspec = dir.findChild("pubspec.yaml");
        if (pubspec == null || !pubspec.exists() || pubspec.isDirectory()) {
            return null;
        }
        VirtualFile packages = dir.findChild(".packages");
        if (packages == null || !packages.exists() || packages.isDirectory()) {
            packages = null;
        }
        if ((lib = dir.findChild("lib")) == null || !lib.exists() || !lib.isDirectory()) {
            lib = null;
        }
        return new PubRoot(dir, pubspec, packages, lib);
    }

    @Nullable
    public static PubRoot forDirectoryWithRefresh(@NotNull VirtualFile dir) {
        if (dir == null) {
            PubRoot.$$$reportNull$$$0(4);
        }
        dir.refresh(false, false);
        return PubRoot.forDirectory(dir);
    }

    @Nullable
    public String getRelativePath(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(5);
        }
        String root = this.root.getPath();
        String path = file.getPath();
        if (!path.startsWith(root) || path.length() < root.length() + 2) {
            return null;
        }
        return path.substring(root.length() + 1);
    }

    public boolean hasTests(@NotNull VirtualFile dir) {
        if (dir == null) {
            PubRoot.$$$reportNull$$$0(6);
        }
        if (!dir.isDirectory()) {
            return false;
        }
        if (this.getRoot().equals(dir)) {
            return true;
        }
        VirtualFile wanted = this.getTestDir();
        if (wanted == null) {
            return false;
        }
        while (dir != null) {
            if (wanted.equals(dir)) {
                return true;
            }
            dir = dir.getParent();
        }
        return false;
    }

    @Nullable
    public PubRoot refresh() {
        return PubRoot.forDirectoryWithRefresh(this.root);
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            PubRoot.$$$reportNull$$$0(7);
        }
        return virtualFile;
    }

    @NotNull
    public String getPath() {
        String string = this.root.getPath();
        if (string == null) {
            PubRoot.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public VirtualFile getPubspec() {
        VirtualFile virtualFile = this.pubspec;
        if (virtualFile == null) {
            PubRoot.$$$reportNull$$$0(9);
        }
        return virtualFile;
    }

    public boolean declaresFlutter() {
        return FlutterUtils.declaresFlutter(this.pubspec);
    }

    public boolean isFlutterPlugin() {
        return FlutterUtils.isFlutterPlugin(this.pubspec);
    }

    @Nullable
    public VirtualFile getPackagesFile() {
        return this.packagesFile;
    }

    public boolean hasUpToDatePackages() {
        return this.packagesFile != null && this.pubspec.getTimeStamp() < this.packagesFile.getTimeStamp();
    }

    @Nullable
    public VirtualFile getLib() {
        return this.lib;
    }

    @Nullable
    public VirtualFile getFileToOpen() {
        VirtualFile[] files;
        VirtualFile main = this.getLibMain();
        if (main != null) {
            return main;
        }
        if (this.lib != null && (files = this.lib.getChildren()).length != 0) {
            return files[0];
        }
        return null;
    }

    @Nullable
    public VirtualFile getLibMain() {
        return this.lib == null ? null : this.lib.findChild("main.dart");
    }

    public VirtualFile getExampleLibMain() {
        VirtualFile libDir;
        VirtualFile exampleDir = this.root.findChild("example");
        if (exampleDir != null && (libDir = exampleDir.findChild("lib")) != null) {
            return libDir.findChild("main.dart");
        }
        return null;
    }

    @Nullable
    public VirtualFile getTestDir() {
        return this.root.findChild("test");
    }

    @Nullable
    public VirtualFile getExampleDir() {
        return this.root.findChild("example");
    }

    @Nullable
    public VirtualFile getAndroidDir() {
        return this.root.findChild("android");
    }

    @Nullable
    public VirtualFile getiOsDir() {
        return this.root.findChild("ios");
    }

    public boolean hasAndroidModule(Project project) {
        VirtualFile androidDir = this.getAndroidDir();
        if (androidDir == null) {
            return false;
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!contentRoot.equals(androidDir)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public Module getModule(@NotNull Project project) {
        if (project == null) {
            PubRoot.$$$reportNull$$$0(10);
        }
        if (project.isDisposed()) {
            return null;
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().getModuleForFile(this.pubspec);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(11);
        }
        for (VirtualFile dir = file.getParent(); dir != null; dir = dir.getParent()) {
            if (!dir.equals(this.root)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "PubRoot(" + this.root.getName() + ")";
    }

    public static boolean isPubspec(@NotNull VirtualFile file) {
        if (file == null) {
            PubRoot.$$$reportNull$$$0(12);
        }
        return !file.isDirectory() && file.getName().equals("pubspec.yaml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspec";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/pub/PubRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/pub/PubRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPubspec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forEventWithRefresh";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forDirectoryWithRefresh";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasTests";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getModule";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPubspec";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

