/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.util.messages.MessageBusConnection;
import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ProjectWatch
implements Closeable {
    @NotNull
    private final Runnable callback;
    private final AtomicReference<Runnable> unsubscribe;
    private static final Logger LOG = Logger.getInstance(ProjectWatch.class);

    private ProjectWatch(@NotNull Project project, @NotNull Runnable callback) {
        if (project == null) {
            ProjectWatch.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            ProjectWatch.$$$reportNull$$$0(1);
        }
        this.unsubscribe = new AtomicReference();
        this.callback = callback;
        ProjectManagerListener listener = new ProjectManagerListener(){

            public void projectClosed(Project project) {
                ProjectWatch.this.fireEvent();
            }
        };
        ProjectManager manager = ProjectManager.getInstance();
        manager.addProjectManagerListener(project, listener);
        MessageBusConnection bus = project.getMessageBus().connect();
        bus.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                ProjectWatch.this.fireEvent();
            }
        });
        this.unsubscribe.set(() -> {
            if (project == null) {
                ProjectWatch.$$$reportNull$$$0(5);
            }
            bus.disconnect();
            manager.removeProjectManagerListener(project, listener);
        });
    }

    @NotNull
    public static ProjectWatch subscribe(@NotNull Project project, @NotNull Runnable callback) {
        if (project == null) {
            ProjectWatch.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            ProjectWatch.$$$reportNull$$$0(3);
        }
        ProjectWatch projectWatch = new ProjectWatch(project, callback);
        if (projectWatch == null) {
            ProjectWatch.$$$reportNull$$$0(4);
        }
        return projectWatch;
    }

    @Override
    public void close() {
        Runnable unsubscribe = this.unsubscribe.getAndSet(null);
        if (unsubscribe != null) {
            unsubscribe.run();
        }
    }

    private void fireEvent() {
        if (this.unsubscribe.get() == null) {
            return;
        }
        try {
            this.callback.run();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception in ProjectWatch callback", (Throwable)e);
            this.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/project/ProjectWatch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/project/ProjectWatch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "subscribe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

