/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.project;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.ElementBase;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.psi.DartFile;
import icons.FlutterIcons;
import io.flutter.FlutterUtils;
import io.flutter.pub.PubRoot;
import io.flutter.utils.FlutterModuleUtils;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterIconProvider
extends IconProvider {
    private static final Icon TEST_FILE = ElementBase.overlayIcons((Icon[])new Icon[]{DartFileType.INSTANCE.getIcon(), AllIcons.Nodes.JunitTestMark});

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        Project project;
        if (element == null) {
            FlutterIconProvider.$$$reportNull$$$0(0);
        }
        if (!FlutterModuleUtils.declaresFlutter(project = element.getProject())) {
            return null;
        }
        if (element instanceof PsiDirectory) {
            VirtualFile file = ((PsiDirectory)element).getVirtualFile();
            if (!file.isInLocalFileSystem()) {
                return null;
            }
            PubRoot pubRoot = PubRoot.forDirectory(file);
            if (pubRoot != null && pubRoot.declaresFlutter()) {
                return FlutterIcons.Flutter;
            }
            PubRoot root = PubRoot.forDirectory(file.getParent());
            if (root == null) {
                return null;
            }
            if (file.equals(root.getLib())) {
                return AllIcons.Modules.SourceRoot;
            }
            if (Objects.equals(file, root.getAndroidDir())) {
                return AllIcons.Nodes.KeymapTools;
            }
            if (Objects.equals(file, root.getiOsDir())) {
                return AllIcons.Nodes.KeymapTools;
            }
            if (file.isDirectory() && file.getName().equals(".idea")) {
                return AllIcons.Modules.GeneratedFolder;
            }
        }
        if (element instanceof DartFile) {
            DartFile dartFile = (DartFile)element;
            VirtualFile file = dartFile.getVirtualFile();
            if (!file.isInLocalFileSystem()) {
                return null;
            }
            if (FlutterUtils.isInTestDir(dartFile) && file.getName().endsWith("_test.dart")) {
                return TEST_FILE;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "io/flutter/project/FlutterIconProvider", "getIcon"));
    }
}

