/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.ui.JBColor;
import io.flutter.preview.Handle;
import io.flutter.preview.SquareHandlePosition;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class SquareHandle
extends Handle {
    private static final int SIZE = 7;
    private final SquareHandlePosition myPosition;

    public SquareHandle(SquareHandlePosition position) {
        this.myPosition = position;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        g.setColor((Color)JBColor.BLACK);
        g.fillRect(0, 0, width, height);
        g.setColor((Color)JBColor.WHITE);
        g.drawRect(0, 0, width, height);
    }

    @Override
    public void updateBounds(Rectangle host) {
        int x = 0;
        int y = 0;
        switch (this.myPosition) {
            case TOP_LEFT: {
                x = host.x;
                y = host.y;
                break;
            }
            case TOP_RIGHT: {
                x = host.x + host.width - 1;
                y = host.y;
                break;
            }
            case BOTTOM_LEFT: {
                x = host.x;
                y = host.y + host.height - 1;
                break;
            }
            case BOTTOM_RIGHT: {
                x = host.x + host.width - 1;
                y = host.y + host.height - 1;
            }
        }
        this.setBounds(x - 3, y - 3, 7, 7);
    }
}

