/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import io.flutter.preview.Handle;
import io.flutter.preview.MoveHandle;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SelectionEditPolicy {
    private final JPanel myHandleLayer;
    private final JComponent myComponent;
    private boolean myIsActive = false;
    private final List<Handle> myHandles = new ArrayList<Handle>();

    public SelectionEditPolicy(JPanel handleLayer, JComponent component) {
        this.myHandleLayer = handleLayer;
        this.myComponent = component;
    }

    public void activate() {
        if (!this.myIsActive) {
            this.myIsActive = true;
            this.myHandles.add(new MoveHandle());
            Rectangle componentBoundsInLayer = SwingUtilities.convertRectangle(this.myComponent.getParent(), this.myComponent.getBounds(), this.myHandleLayer);
            for (Handle handle : this.myHandles) {
                handle.updateBounds(componentBoundsInLayer);
                this.myHandleLayer.add(handle);
            }
        }
    }

    public void deactivate() {
        if (this.myIsActive) {
            this.myIsActive = false;
            for (Handle handle : this.myHandles) {
                Container parent = handle.getParent();
                if (parent == null) continue;
                parent.remove(handle);
            }
            this.myHandles.clear();
        }
    }
}

