/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.common.io.Resources;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import io.flutter.preview.RenderHelper;
import io.flutter.preview.RenderProblemKind;
import io.flutter.preview.RenderRequest;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.run.daemon.FlutterDevice;
import io.flutter.run.daemon.RunMode;
import io.flutter.sdk.FlutterCommand;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RenderThread
extends Thread {
    final Object myRequestLock = new Object();
    RenderRequest myLastRequest;
    RenderRequest myNextRequest;
    RenderRequest myProcessRequest;
    FlutterApp myApp;

    RenderThread() {
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(@Nullable RenderRequest request) {
        Object object = this.myRequestLock;
        synchronized (object) {
            if (this.myLastRequest != null) {
                this.myLastRequest.isActive = false;
                this.myLastRequest = null;
            }
            this.myNextRequest = request;
            this.myRequestLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            RenderRequest request;
            try {
                while (true) {
                    Object object = this.myRequestLock;
                    synchronized (object) {
                        if (this.myNextRequest == null) {
                            this.myRequestLock.wait();
                        }
                        this.myLastRequest = this.myNextRequest;
                        request = this.myNextRequest;
                        this.myNextRequest = null;
                        if (request != null) break;
                    }
                }
                {
                }
            }
            catch (InterruptedException ignored) {
                continue;
            }
            this.render(request);
        }
    }

    private void render(@NotNull RenderRequest request) {
        if (request == null) {
            RenderThread.$$$reportNull$$$0(0);
        }
        FlutterOutline widget = request.widget;
        try {
            String packagePath = request.pubRoot.getPath();
            File dartToolDirectory = new File(packagePath, ".dart_tool");
            File flutterDirectory = new File(dartToolDirectory, "flutter");
            File designerDirectory = new File(flutterDirectory, "designer");
            File toRenderFile = new File(designerDirectory, "to_render.dart");
            FileUtil.writeToFile((File)toRenderFile, (String)request.codeToRender);
            String widgetCreation = "new " + request.widgetClass + "." + request.widgetConstructor + "();";
            URL templateUri = RenderHelper.class.getResource("render_server_template.txt");
            String template = Resources.toString((URL)templateUri, (Charset)StandardCharsets.UTF_8);
            template = template.replace("// TEMPLATE_VALUE: import library to render", "import '" + toRenderFile.getName() + "';");
            template = template.replace("new Container(); // TEMPLATE_VALUE: create widget", widgetCreation);
            template = template.replace("{}; // TEMPLATE_VALUE: use flutterDesignerWidgets", "flutterDesignerWidgets;");
            template = template.replace("350.0 /*TEMPLATE_VALUE: width*/", request.width + ".0");
            template = template.replace("400.0 /*TEMPLATE_VALUE: height*/", request.height + ".0");
            File renderServerFile = new File(designerDirectory, "render_server.dart");
            String renderServerPath = renderServerFile.getPath();
            FileUtil.writeToFile((File)renderServerFile, (String)template);
            if (this.myApp != null && !this.myApp.isConnected()) {
                this.myProcessRequest = null;
                this.myApp = null;
            }
            boolean canRenderWithCurrentProcess = false;
            if (this.myProcessRequest != null && this.myApp != null) {
                if (Objects.equals(this.myProcessRequest.pubRoot.getPath(), packagePath)) {
                    try {
                        DaemonApi.RestartResult restartResult = this.myApp.performHotReload(false).get(5000L, TimeUnit.MILLISECONDS);
                        if (restartResult.ok()) {
                            canRenderWithCurrentProcess = true;
                        }
                    }
                    catch (Throwable restartResult) {
                        // empty catch block
                    }
                }
                if (!canRenderWithCurrentProcess) {
                    this.terminateCurrentProcess("Project root or file changed, or reload failed");
                }
            }
            if (this.myApp == null) {
                FlutterCommand command = request.flutterSdk.flutterRunOnTester(request.pubRoot, renderServerPath);
                GeneralCommandLine commandLine = command.createGeneralCommandLine(request.project);
                commandLine.getEnvironment().put("FLUTTER_TEST", "true");
                FlutterApp app = FlutterApp.start(new ExecutionEnvironment(), request.project, request.module, RunMode.DEBUG, FlutterDevice.getTester(), commandLine, null, null);
                final CountDownLatch startedLatch = new CountDownLatch(1);
                app.addStateListener(new FlutterApp.FlutterAppListener(){

                    @Override
                    public void stateChanged(FlutterApp.State newState) {
                        if (newState == FlutterApp.State.STARTED) {
                            startedLatch.countDown();
                        }
                        if (newState == FlutterApp.State.TERMINATING) {
                            RenderThread.this.myProcessRequest = null;
                            RenderThread.this.myApp = null;
                        }
                    }
                });
                boolean started = Uninterruptibles.awaitUninterruptibly((CountDownLatch)startedLatch, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
                if (!started) {
                    this.terminateCurrentProcess("Initial start timeout.");
                    this.invokeIfSameRequest(request, () -> {
                        if (request == null) {
                            RenderThread.$$$reportNull$$$0(5);
                        }
                        request.listener.onFailure(RenderProblemKind.TIMEOUT_START, request.widget);
                    });
                    return;
                }
                this.myProcessRequest = request;
                this.myApp = app;
            }
            CountDownLatch responseReceivedLatch = new CountDownLatch(1);
            AtomicReference responseRef = new AtomicReference();
            this.myApp.callServiceExtension("ext.flutter.designer.render").thenAccept(response -> {
                responseRef.set(response);
                responseReceivedLatch.countDown();
            });
            boolean responseReceived = Uninterruptibles.awaitUninterruptibly((CountDownLatch)responseReceivedLatch, (long)4000L, (TimeUnit)TimeUnit.MILLISECONDS);
            if (!responseReceived) {
                this.terminateCurrentProcess("Render response timeout.");
                this.invokeIfSameRequest(request, () -> {
                    if (request == null) {
                        RenderThread.$$$reportNull$$$0(4);
                    }
                    request.listener.onFailure(RenderProblemKind.TIMEOUT_RENDER, widget);
                });
                return;
            }
            JsonObject response2 = (JsonObject)responseRef.get();
            if (response2.has("exception")) {
                this.invokeIfSameRequest(request, () -> {
                    if (request == null) {
                        RenderThread.$$$reportNull$$$0(3);
                    }
                    request.listener.onRemoteException(widget, response2);
                });
                return;
            }
            this.invokeIfSameRequest(request, () -> {
                if (request == null) {
                    RenderThread.$$$reportNull$$$0(2);
                }
                request.listener.onResponse(widget, response2);
            });
        }
        catch (Throwable e) {
            this.terminateCurrentProcess("Exception");
            this.invokeIfSameRequest(request, () -> {
                if (request == null) {
                    RenderThread.$$$reportNull$$$0(1);
                }
                request.listener.onLocalException(widget, e);
            });
        }
    }

    private void invokeIfSameRequest(RenderRequest request, Runnable runnable) {
        if (request.isActive) {
            runnable.run();
        }
    }

    private void terminateCurrentProcess(String reason) {
        this.myProcessRequest = null;
        if (this.myApp != null) {
            this.myApp.getProcessHandler().destroyProcess();
            this.myApp = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "request";
        objectArray2[1] = "io/flutter/preview/RenderThread";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$render$5";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$render$4";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$render$3";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$render$2";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$render$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

