/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.gson.JsonObject;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.preview.RenderProblemKind;
import io.flutter.preview.RenderRequest;
import io.flutter.preview.RenderThread;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderHelper {
    private final Project myProject;
    private final Listener myListener;
    private final FlutterSdk myFlutterSdk;
    private final RenderThread myRenderThread;
    private PubRoot myPubRoot;
    private Module myModule;
    private VirtualFile myFile;
    private FlutterOutline myFileOutline;
    private String myInstrumentedCode;
    private FlutterOutline myWidgetOutline;
    private int myWidth;
    private int myHeight;

    public RenderHelper(@NotNull Project project, @NotNull Listener listener) {
        if (project == null) {
            RenderHelper.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            RenderHelper.$$$reportNull$$$0(1);
        }
        this.myRenderThread = new RenderThread();
        this.myWidth = 0;
        this.myHeight = 0;
        this.myProject = project;
        this.myListener = listener;
        this.myFlutterSdk = FlutterSdk.getFlutterSdk(this.myProject);
        this.myRenderThread.start();
    }

    public void setFile(@Nullable VirtualFile file, @Nullable FlutterOutline fileOutline, @Nullable String instrumentedCode) {
        this.myFile = file;
        this.myFileOutline = fileOutline;
        this.myInstrumentedCode = instrumentedCode;
        this.myPubRoot = PubRoot.forFile(file);
        if (this.myPubRoot != null) {
            this.myModule = this.myPubRoot.getModule(this.myProject);
        }
        this.myWidgetOutline = null;
    }

    public void setSize(int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
        this.scheduleRendering();
    }

    public void setOffset(int offset) {
        FlutterOutline previousWidgetOutline = this.myWidgetOutline;
        this.myWidgetOutline = this.getContainingWidgetOutline(offset);
        if (this.myWidgetOutline == null) {
            this.myRenderThread.setRequest(null);
            this.myListener.onFailure(RenderProblemKind.NO_WIDGET, null);
        } else if (this.myWidgetOutline.getRenderConstructor() == null) {
            this.myRenderThread.setRequest(null);
            this.myListener.onFailure(RenderProblemKind.NOT_RENDERABLE_WIDGET, this.myWidgetOutline);
            this.myWidgetOutline = null;
        } else if (this.myWidgetOutline != previousWidgetOutline) {
            this.myListener.onRenderableWidget(this.myWidgetOutline);
            this.scheduleRendering();
        }
    }

    private FlutterOutline getContainingWidgetOutline(int offset) {
        if (this.myFileOutline != null && this.myFileOutline.getChildren() != null) {
            for (FlutterOutline outline : this.myFileOutline.getChildren()) {
                int outlineStart = this.getConvertedFileOffset(outline.getOffset());
                int outlineEnd = this.getConvertedFileOffset(outline.getOffset() + outline.getLength());
                int stateStart = -1;
                int stateEnd = -1;
                if (outline.getStateOffset() != null && outline.getStateLength() != null) {
                    stateStart = this.getConvertedFileOffset(outline.getStateOffset());
                    stateEnd = this.getConvertedFileOffset(outline.getStateOffset() + outline.getStateLength());
                }
                if ((outlineStart >= offset || offset >= outlineEnd) && (stateStart >= offset || offset >= stateEnd)) continue;
                if (outline.isWidgetClass()) {
                    return outline;
                }
                return null;
            }
        }
        return null;
    }

    private int getConvertedFileOffset(int offset) {
        return DartAnalysisServerService.getInstance((Project)this.myProject).getConvertedOffset(this.myFile, offset);
    }

    private void scheduleRendering() {
        if (this.myPubRoot == null || this.myModule == null || this.myInstrumentedCode == null || this.myWidgetOutline == null || this.myWidth == 0 || this.myHeight == 0) {
            return;
        }
        if (this.myFlutterSdk == null) {
            return;
        }
        String widgetClass = this.myWidgetOutline.getDartElement().getName();
        String constructor = this.myWidgetOutline.getRenderConstructor();
        RenderRequest request = new RenderRequest(this.myFlutterSdk, this.myProject, this.myPubRoot, this.myModule, this.myInstrumentedCode, this.myWidgetOutline, widgetClass, constructor, this.myWidth, this.myHeight, this.myListener);
        this.myRenderThread.setRequest(request);
        this.myListener.onSchedule(this.myWidgetOutline);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "listener";
                break;
            }
        }
        objectArray[1] = "io/flutter/preview/RenderHelper";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public void onSchedule(@NotNull FlutterOutline var1);

        public void onResponse(@NotNull FlutterOutline var1, @NotNull JsonObject var2);

        public void onFailure(@NotNull RenderProblemKind var1, @Nullable FlutterOutline var2);

        public void onRenderableWidget(@NotNull FlutterOutline var1);

        public void onLocalException(@NotNull FlutterOutline var1, @NotNull Throwable var2);

        public void onRemoteException(@NotNull FlutterOutline var1, @NotNull JsonObject var2);
    }
}

