/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.JsonObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import icons.FlutterIcons;
import io.flutter.FlutterInitializer;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.console.FlutterConsoles;
import io.flutter.dart.FlutterDartAnalysisServer;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.preview.ModelUtils;
import io.flutter.preview.OutlineComponent;
import io.flutter.preview.OutlineObject;
import io.flutter.preview.OutlineTree;
import io.flutter.preview.OutlineTreeCellRenderer;
import io.flutter.preview.PreviewArea;
import io.flutter.preview.PreviewViewState;
import io.flutter.preview.RenderHelper;
import io.flutter.preview.RenderProblemKind;
import io.flutter.preview.TextOnlyActionWrapper;
import io.flutter.settings.FlutterSettings;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FlutterPreviewView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PreviewView
implements PersistentStateComponent<PreviewViewState>,
Disposable {
    public static final String TOOL_WINDOW_ID = "Flutter Outline";
    public static final String FEEDBACK_URL = "https://goo.gl/forms/MbPU0kcPqBO6tunH3";
    @NotNull
    private final PreviewViewState state;
    @NotNull
    private final Project project;
    @NotNull
    private final FlutterDartAnalysisServer flutterAnalysisServer;
    final QuickAssistAction actionCenter;
    final QuickAssistAction actionPadding;
    final QuickAssistAction actionColumn;
    final QuickAssistAction actionRow;
    final QuickAssistAction actionMoveUp;
    final QuickAssistAction actionMoveDown;
    final QuickAssistAction actionRemove;
    final ExtractMethodAction actionExtractMethod;
    private SimpleToolWindowPanel windowPanel;
    private ActionToolbar windowToolbar;
    private final Map<String, AnAction> messageToActionMap;
    private final Map<AnAction, SourceChange> actionToChangeMap;
    private boolean isSettingSplitterProportion;
    private Splitter splitter;
    private JScrollPane scrollPane;
    private OutlineTree tree;
    private PreviewArea previewArea;
    private final Set<FlutterOutline> outlinesWithWidgets;
    private final Map<FlutterOutline, DefaultMutableTreeNode> outlineToNodeMap;
    private VirtualFile currentFile;
    private String currentFilePath;
    FileEditor currentFileEditor;
    private Editor currentEditor;
    private FlutterOutline currentOutline;
    private final RenderHelper myRenderHelper;
    private final FlutterOutlineListener outlineListener;
    private final CaretListener caretListener;
    private final TreeSelectionListener treeSelectionListener;
    final RenderHelper.Listener renderListener;

    private void minimizePreviewArea() {
        this.setSplitterProportion(0.85f);
    }

    public PreviewView(@NotNull Project project) {
        FileEditor[] selectedEditors;
        if (project == null) {
            PreviewView.$$$reportNull$$$0(0);
        }
        this.state = new PreviewViewState();
        this.messageToActionMap = new HashMap<String, AnAction>();
        this.actionToChangeMap = new HashMap<AnAction, SourceChange>();
        this.isSettingSplitterProportion = false;
        this.outlinesWithWidgets = Sets.newHashSet();
        this.outlineToNodeMap = Maps.newHashMap();
        this.outlineListener = new FlutterOutlineListener(){

            @Override
            public void outlineUpdated(@NotNull String filePath, @NotNull FlutterOutline outline, @Nullable String instrumentedCode) {
                if (filePath == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outline == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (Objects.equals(PreviewView.this.currentFilePath, filePath)) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (outline == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        PreviewView.this.updateOutline(outline);
                    });
                    if (PreviewView.this.myRenderHelper != null && PreviewView.this.previewArea != null) {
                        PreviewView.this.previewArea.renderingStarted();
                        PreviewView.this.myRenderHelper.setFile(PreviewView.this.currentFile, outline, instrumentedCode);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            Caret caret = PreviewView.this.currentEditor.getCaretModel().getPrimaryCaret();
                            PreviewView.this.myRenderHelper.setOffset(caret.getOffset());
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filePath";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outline";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/preview/PreviewView$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "outlineUpdated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$outlineUpdated$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.caretListener = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                Caret caret = e.getCaret();
                if (caret != null) {
                    ApplicationManager.getApplication().invokeLater(() -> PreviewView.this.applyEditorSelectionToTree(caret));
                }
            }

            public void caretAdded(CaretEvent e) {
            }

            public void caretRemoved(CaretEvent e) {
            }
        };
        this.treeSelectionListener = this::handleTreeSelectionEvent;
        this.renderListener = new RenderHelper.Listener(){

            @Override
            public void onSchedule(@NotNull FlutterOutline widget) {
                if (widget == null) {
                    3.$$$reportNull$$$0(0);
                }
            }

            @Override
            public void onResponse(@NotNull FlutterOutline widget, @NotNull JsonObject response) {
                if (widget == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (response == null) {
                    3.$$$reportNull$$$0(2);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (widget == null) {
                        3.$$$reportNull$$$0(12);
                    }
                    if (response == null) {
                        3.$$$reportNull$$$0(13);
                    }
                    if (PreviewView.this.previewArea != null) {
                        PreviewView.this.previewArea.show(PreviewView.this.currentOutline, widget, response);
                        Caret caret = PreviewView.this.currentEditor.getCaretModel().getPrimaryCaret();
                        FlutterOutline outline = PreviewView.this.findOutlineAtOffset(PreviewView.this.currentOutline, caret.getOffset());
                        if (outline != null) {
                            PreviewView.this.previewArea.select((List<FlutterOutline>)ImmutableList.of((Object)outline));
                        }
                    }
                });
            }

            @Override
            public void onFailure(@NotNull RenderProblemKind kind, @Nullable FlutterOutline widget) {
                if (kind == null) {
                    3.$$$reportNull$$$0(3);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (kind == null) {
                        3.$$$reportNull$$$0(11);
                    }
                    if (PreviewView.this.previewArea != null) {
                        switch (kind) {
                            case NO_WIDGET: {
                                PreviewView.this.previewArea.clear("No widget selected");
                                PreviewView.this.minimizePreviewArea();
                                break;
                            }
                            case NOT_RENDERABLE_WIDGET: {
                                assert (widget != null);
                                PreviewView.this.showNotRenderableInPreviewArea(widget);
                                break;
                            }
                            case TIMEOUT_START: {
                                PreviewView.this.previewArea.clear("Timeout during start");
                                break;
                            }
                            case TIMEOUT_RENDER: {
                                PreviewView.this.previewArea.clear("Timeout during rendering");
                                break;
                            }
                            case INVALID_JSON: {
                                PreviewView.this.previewArea.clear("Invalid JSON response");
                            }
                        }
                    }
                });
            }

            @Override
            public void onRenderableWidget(@NotNull FlutterOutline widget) {
                if (widget == null) {
                    3.$$$reportNull$$$0(4);
                }
                PreviewView.this.setSplitterProportion(PreviewView.this.getState().getSplitterProportion());
                Dimension renderSize = PreviewView.this.previewArea.getRenderSize();
                PreviewView.this.myRenderHelper.setSize(renderSize.width, renderSize.height);
            }

            @Override
            public void onLocalException(@NotNull FlutterOutline widget, @NotNull Throwable localException) {
                if (widget == null) {
                    3.$$$reportNull$$$0(5);
                }
                if (localException == null) {
                    3.$$$reportNull$$$0(6);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (localException == null) {
                        3.$$$reportNull$$$0(10);
                    }
                    PreviewView.this.showLocalException(localException);
                });
            }

            @Override
            public void onRemoteException(@NotNull FlutterOutline widget, @NotNull JsonObject remoteException) {
                if (widget == null) {
                    3.$$$reportNull$$$0(7);
                }
                if (remoteException == null) {
                    3.$$$reportNull$$$0(8);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (remoteException == null) {
                        3.$$$reportNull$$$0(9);
                    }
                    PreviewView.this.showRemoteException(remoteException);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "widget";
                        break;
                    }
                    case 2: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "response";
                        break;
                    }
                    case 3: 
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "kind";
                        break;
                    }
                    case 6: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "localException";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "remoteException";
                        break;
                    }
                }
                objectArray2[1] = "io/flutter/preview/PreviewView$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSchedule";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onResponse";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFailure";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onRenderableWidget";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onLocalException";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onRemoteException";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onRemoteException$3";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onLocalException$2";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onFailure$1";
                        break;
                    }
                    case 12: 
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$onResponse$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.project = project;
        this.flutterAnalysisServer = FlutterDartAnalysisServer.getInstance(project);
        this.myRenderHelper = FlutterSettings.getInstance().isShowPreviewArea() ? new RenderHelper(project, this.renderListener) : null;
        VirtualFile[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (selectedFiles.length != 0) {
            this.setSelectedFile(selectedFiles[0]);
        }
        if ((selectedEditors = FileEditorManager.getInstance((Project)project).getSelectedEditors()).length != 0) {
            this.setSelectedEditor(selectedEditors[0]);
        }
        MessageBusConnection bus = project.getMessageBus().connect((Disposable)project);
        bus.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                PreviewView.this.setSelectedFile(event.getNewFile());
                PreviewView.this.setSelectedEditor(event.getNewEditor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/preview/PreviewView$4", "selectionChanged"));
            }
        });
        this.actionCenter = new QuickAssistAction("dart.assist.flutter.wrap.center", FlutterIcons.Center, "Center widget");
        this.actionPadding = new QuickAssistAction("dart.assist.flutter.wrap.padding", FlutterIcons.Padding, "Add padding");
        this.actionColumn = new QuickAssistAction("dart.assist.flutter.wrap.column", FlutterIcons.Column, "Wrap with Column");
        this.actionRow = new QuickAssistAction("dart.assist.flutter.wrap.row", FlutterIcons.Row, "Wrap with Row");
        this.actionMoveUp = new QuickAssistAction("dart.assist.flutter.move.up", FlutterIcons.Up, "Move widget up");
        this.actionMoveDown = new QuickAssistAction("dart.assist.flutter.move.down", FlutterIcons.Down, "Move widget down");
        this.actionRemove = new QuickAssistAction("dart.assist.flutter.removeWidget", FlutterIcons.RemoveWidget, "Remove widget");
        this.actionExtractMethod = new ExtractMethodAction();
    }

    public void dispose() {
    }

    @NotNull
    public PreviewViewState getState() {
        PreviewViewState previewViewState = this.state;
        if (previewViewState == null) {
            PreviewView.$$$reportNull$$$0(1);
        }
        return previewViewState;
    }

    public void loadState(@NotNull PreviewViewState state) {
        if (state == null) {
            PreviewView.$$$reportNull$$$0(2);
        }
        this.state.copyFrom(state);
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            PreviewView.$$$reportNull$$$0(3);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ContentManager contentManager = toolWindow.getContentManager();
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)this.actionCenter);
        toolbarGroup.add((AnAction)this.actionPadding);
        toolbarGroup.add((AnAction)this.actionColumn);
        toolbarGroup.add((AnAction)this.actionRow);
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.actionExtractMethod);
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.actionMoveUp);
        toolbarGroup.add((AnAction)this.actionMoveDown);
        toolbarGroup.addSeparator();
        toolbarGroup.add((AnAction)this.actionRemove);
        toolbarGroup.add((AnAction)new ShowOnlyWidgetsAction(AllIcons.General.Filter, "Show only widgets"));
        Content content = contentFactory.createContent(null, null, false);
        content.setCloseable(false);
        this.windowPanel = new OutlineComponent(this);
        content.setComponent((JComponent)this.windowPanel);
        this.windowToolbar = ActionManager.getInstance().createActionToolbar("PreviewViewToolbar", (ActionGroup)toolbarGroup, true);
        this.windowPanel.setToolbar(this.windowToolbar.getComponent());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.tree = new OutlineTree(rootNode);
        this.tree.setCellRenderer((TreeCellRenderer)((Object)new OutlineTreeCellRenderer()));
        this.tree.expandAll();
        this.initTreePopup();
        if (toolWindow instanceof ToolWindowEx) {
            AnAction sendFeedbackAction = new AnAction("Send Feedback", "Send Feedback", FlutterIcons.Feedback){

                public void actionPerformed(AnActionEvent event) {
                    BrowserUtil.browse((String)PreviewView.FEEDBACK_URL);
                }
            };
            AnAction separator = new AnAction(AllIcons.General.Divider){

                public void actionPerformed(AnActionEvent event) {
                }
            };
            DefaultTreeExpander expander = new DefaultTreeExpander((JTree)((Object)this.tree));
            CommonActionsManager actions = CommonActionsManager.getInstance();
            AnAction expandAllAction = actions.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this.tree));
            expandAllAction.getTemplatePresentation().setIcon(AllIcons.General.ExpandAll);
            AnAction collapseAllAction = actions.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this.tree));
            collapseAllAction.getTemplatePresentation().setIcon(AllIcons.General.CollapseAll);
            ((ToolWindowEx)toolWindow).setTitleActions(new AnAction[]{sendFeedbackAction, separator, expandAllAction, collapseAllAction});
        }
        new TreeSpeedSearch((JTree)((Object)this.tree)){

            protected String getElementText(Object element) {
                TreePath path = (TreePath)element;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object object = node.getUserObject();
                if (object instanceof OutlineObject) {
                    return ((OutlineObject)object).getSpeedSearchString();
                }
                return null;
            }
        };
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath selectionPath;
                if (e.getClickCount() > 1 && (selectionPath = PreviewView.this.tree.getSelectionPath()) != null) {
                    PreviewView.this.selectPath(selectionPath, true);
                }
            }
        });
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.tree));
        this.previewArea = new PreviewArea(new PreviewArea.Listener(){

            @Override
            public void clicked(FlutterOutline outline) {
                ImmutableList outlines = ImmutableList.of((Object)outline);
                PreviewView.this.updateActionsForOutlines((List)outlines);
                PreviewView.this.applyOutlinesSelectionToTree((List)outlines);
                PreviewView.this.jumpToOutlineInEditor(outline, false);
            }

            @Override
            public void doubleClicked(FlutterOutline outline) {
                ImmutableList outlines = ImmutableList.of((Object)outline);
                PreviewView.this.updateActionsForOutlines((List)outlines);
                PreviewView.this.applyOutlinesSelectionToTree((List)outlines);
                PreviewView.this.jumpToOutlineInEditor(outline, true);
            }

            @Override
            public void resized(int width, int height) {
                if (PreviewView.this.myRenderHelper != null) {
                    PreviewView.this.myRenderHelper.setSize(width, height);
                }
            }
        });
        this.splitter = new Splitter(true);
        this.setSplitterProportion(this.getState().getSplitterProportion());
        this.getState().addListener(e -> {
            float newProportion = this.getState().getSplitterProportion();
            if (this.splitter.getProportion() != newProportion) {
                this.setSplitterProportion(newProportion);
            }
        });
        this.splitter.addPropertyChangeListener("proportion", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!PreviewView.this.isSettingSplitterProportion) {
                    PreviewView.this.getState().setSplitterProportion(PreviewView.this.splitter.getProportion());
                }
            }
        });
        this.splitter.setFirstComponent((JComponent)this.scrollPane);
        this.windowPanel.setContent((JComponent)this.splitter);
        contentManager.addContent(content);
        contentManager.setSelectedContent(content);
    }

    private void initTreePopup() {
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                List selectedOutlines = PreviewView.this.getOutlinesSelectedInTree();
                if (selectedOutlines.isEmpty()) {
                    return;
                }
                for (FlutterOutline outline : selectedOutlines) {
                    if (outline.getDartElement() == null) continue;
                    return;
                }
                for (int i = 0; i < 20 && PreviewView.this.actionToChangeMap.isEmpty(); ++i) {
                    Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
                }
                DefaultActionGroup group = new DefaultActionGroup();
                boolean hasAction = false;
                if (PreviewView.this.actionCenter.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionCenter));
                }
                if (PreviewView.this.actionPadding.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionPadding));
                }
                if (PreviewView.this.actionColumn.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionColumn));
                }
                if (PreviewView.this.actionRow.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionRow));
                }
                group.addSeparator();
                if (PreviewView.this.actionExtractMethod.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionExtractMethod));
                }
                group.addSeparator();
                if (PreviewView.this.actionMoveUp.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionMoveUp));
                }
                if (PreviewView.this.actionMoveDown.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionMoveDown));
                }
                group.addSeparator();
                if (PreviewView.this.actionRemove.isEnabled()) {
                    hasAction = true;
                    group.add((AnAction)new TextOnlyActionWrapper(PreviewView.this.actionRemove));
                }
                if (!hasAction) {
                    return;
                }
                ActionManager actionManager = ActionManager.getInstance();
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu("unknown", (ActionGroup)group);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
    }

    private void handleTreeSelectionEvent(TreeSelectionEvent e) {
        TreePath selectionPath = e.getNewLeadSelectionPath();
        if (selectionPath != null) {
            ApplicationManager.getApplication().invokeLater(() -> this.selectPath(selectionPath, false));
        }
        List<FlutterOutline> selectedOutlines = this.getOutlinesSelectedInTree();
        this.updateActionsForOutlines(selectedOutlines);
    }

    private void selectPath(TreePath selectionPath, boolean focusEditor) {
        FlutterOutline outline = this.getOutlineOfPath(selectionPath);
        this.jumpToOutlineInEditor(outline, focusEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jumpToOutlineInEditor(FlutterOutline outline, boolean focusEditor) {
        if (outline == null) {
            return;
        }
        int offset = outline.getDartElement() != null ? outline.getDartElement().getLocation().getOffset() : outline.getOffset();
        int editorOffset = this.getConvertedFileOffset(offset);
        this.sendAnalyticEvent("jumpToSource");
        if (this.currentFile != null) {
            this.currentEditor.getCaretModel().removeCaretListener(this.caretListener);
            try {
                new OpenFileDescriptor(this.project, this.currentFile, editorOffset).navigate(focusEditor);
            }
            finally {
                this.currentEditor.getCaretModel().addCaretListener(this.caretListener);
            }
        }
        if (this.myRenderHelper != null) {
            this.myRenderHelper.setOffset(editorOffset);
            this.previewArea.select((List<FlutterOutline>)ImmutableList.of((Object)outline));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActionsForOutlines(List<FlutterOutline> outlines) {
        Map<AnAction, SourceChange> map = this.actionToChangeMap;
        synchronized (map) {
            this.actionToChangeMap.clear();
        }
        VirtualFile selectionFile = this.currentFile;
        if (selectionFile != null && !outlines.isEmpty()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                FlutterOutline firstOutline = (FlutterOutline)outlines.get(0);
                FlutterOutline lastOutline = (FlutterOutline)outlines.get(outlines.size() - 1);
                int offset = this.getConvertedOutlineOffset(firstOutline);
                int length = this.getConvertedOutlineEnd(lastOutline) - offset;
                List<SourceChange> changes = this.flutterAnalysisServer.edit_getAssists(selectionFile, offset, length);
                List<FlutterOutline> newOutlines = this.getOutlinesSelectedInTree();
                if (!Objects.equals(this.currentFile, selectionFile) || !outlines.equals(newOutlines)) {
                    return;
                }
                for (SourceChange change : changes) {
                    AnAction action = this.messageToActionMap.get(change.getMessage());
                    if (action == null) continue;
                    this.actionToChangeMap.put(action, change);
                }
                if (this.windowToolbar != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.windowToolbar.updateActionsImmediately());
                }
            });
        }
    }

    private Element getElementParentFor(@Nullable Element element) {
        if (element == null) {
            return null;
        }
        for (FlutterOutline outline : this.outlineToNodeMap.keySet()) {
            List<FlutterOutline> children = outline.getChildren();
            if (children == null) continue;
            for (FlutterOutline child : children) {
                if (child.getDartElement() != element) continue;
                return outline.getDartElement();
            }
        }
        return null;
    }

    private DefaultTreeModel getTreeModel() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    private DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getTreeModel().getRoot();
    }

    private void updateOutline(@NotNull FlutterOutline outline) {
        if (outline == null) {
            PreviewView.$$$reportNull$$$0(4);
        }
        this.currentOutline = outline;
        DefaultMutableTreeNode rootNode = this.getRootNode();
        rootNode.removeAllChildren();
        this.outlinesWithWidgets.clear();
        this.outlineToNodeMap.clear();
        if (outline.getChildren() != null) {
            this.computeOutlinesWithWidgets(outline);
            this.updateOutlineImpl(rootNode, outline.getChildren());
        }
        this.getTreeModel().reload(rootNode);
        this.tree.expandAll();
        if (this.currentEditor != null) {
            Caret caret = this.currentEditor.getCaretModel().getPrimaryCaret();
            this.applyEditorSelectionToTree(caret);
        }
        if (FlutterSettings.getInstance().isShowPreviewArea()) {
            if (ModelUtils.containsBuildMethod(outline)) {
                this.splitter.setSecondComponent(this.previewArea.getComponent());
            } else {
                this.splitter.setSecondComponent(null);
            }
        }
    }

    private boolean computeOutlinesWithWidgets(FlutterOutline outline) {
        List<FlutterOutline> children;
        boolean hasWidget = false;
        if (outline.getDartElement() == null) {
            this.outlinesWithWidgets.add(outline);
            hasWidget = true;
        }
        if ((children = outline.getChildren()) != null) {
            for (FlutterOutline child : children) {
                if (!this.computeOutlinesWithWidgets(child)) continue;
                this.outlinesWithWidgets.add(outline);
                hasWidget = true;
            }
        }
        return hasWidget;
    }

    private void updateOutlineImpl(@NotNull DefaultMutableTreeNode parent, @NotNull List<FlutterOutline> outlines) {
        if (parent == null) {
            PreviewView.$$$reportNull$$$0(5);
        }
        if (outlines == null) {
            PreviewView.$$$reportNull$$$0(6);
        }
        int index = 0;
        for (FlutterOutline outline : outlines) {
            if (FlutterSettings.getInstance().isShowOnlyWidgets() && !this.outlinesWithWidgets.contains(outline)) continue;
            OutlineObject object = new OutlineObject(outline);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(object);
            this.outlineToNodeMap.put(outline, node);
            this.getTreeModel().insertNodeInto(node, parent, index++);
            if (outline.getChildren() == null) continue;
            this.updateOutlineImpl(node, outline.getChildren());
        }
    }

    @NotNull
    private List<FlutterOutline> getOutlinesSelectedInTree() {
        DefaultMutableTreeNode[] selectedNodes;
        ArrayList<FlutterOutline> selectedOutlines = new ArrayList<FlutterOutline>();
        for (DefaultMutableTreeNode selectedNode : selectedNodes = (DefaultMutableTreeNode[])this.tree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            FlutterOutline outline = PreviewView.getOutlineOfNode(selectedNode);
            selectedOutlines.add(outline);
        }
        ArrayList<FlutterOutline> arrayList = selectedOutlines;
        if (arrayList == null) {
            PreviewView.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static FlutterOutline getOutlineOfNode(DefaultMutableTreeNode node) {
        OutlineObject object = (OutlineObject)node.getUserObject();
        return object.outline;
    }

    @Nullable
    private FlutterOutline getOutlineOfPath(@Nullable TreePath path) {
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return PreviewView.getOutlineOfNode(node);
    }

    private int getConvertedFileOffset(int offset) {
        return DartAnalysisServerService.getInstance((Project)this.project).getConvertedOffset(this.currentFile, offset);
    }

    private int getConvertedOutlineOffset(FlutterOutline outline) {
        int offset = outline.getOffset();
        return this.getConvertedFileOffset(offset);
    }

    private int getConvertedOutlineEnd(FlutterOutline outline) {
        int end = outline.getOffset() + outline.getLength();
        return this.getConvertedFileOffset(end);
    }

    private FlutterOutline findOutlineAtOffset(FlutterOutline outline, int offset) {
        if (outline == null) {
            return null;
        }
        if (this.getConvertedOutlineOffset(outline) <= offset && offset <= this.getConvertedOutlineEnd(outline)) {
            if (outline.getChildren() != null) {
                for (FlutterOutline child : outline.getChildren()) {
                    FlutterOutline foundChild = this.findOutlineAtOffset(child, offset);
                    if (foundChild == null) continue;
                    return foundChild;
                }
            }
            return outline;
        }
        return null;
    }

    private void addOutlinesCoveredByRange(List<FlutterOutline> covered, int start, int end, @Nullable FlutterOutline outline) {
        if (outline == null) {
            return;
        }
        int outlineStart = this.getConvertedOutlineOffset(outline);
        int outlineEnd = this.getConvertedOutlineEnd(outline);
        if (outlineEnd < start || outlineStart > end) {
            return;
        }
        if (outlineStart >= start && outlineEnd <= end) {
            covered.add(outline);
            return;
        }
        if (outlineStart <= start && end <= outlineEnd && outline.getChildren() != null) {
            for (FlutterOutline child : outline.getChildren()) {
                this.addOutlinesCoveredByRange(covered, start, end, child);
            }
        }
    }

    private void setSelectedFile(VirtualFile newFile) {
        if (this.currentFile != null) {
            this.flutterAnalysisServer.removeOutlineListener(this.currentFilePath, this.outlineListener);
            this.currentFile = null;
            this.currentFilePath = null;
        }
        if (newFile != null && !FlutterUtils.isDartFile(newFile)) {
            newFile = null;
        }
        if (this.windowPanel != null) {
            if (newFile != null) {
                this.windowPanel.setToolbar(this.windowToolbar.getComponent());
            } else if (this.windowPanel.isToolbarVisible()) {
                this.windowPanel.setToolbar(null);
            }
        }
        if (this.tree != null) {
            DefaultMutableTreeNode rootNode = this.getRootNode();
            rootNode.removeAllChildren();
            this.getTreeModel().reload(rootNode);
        }
        if (this.myRenderHelper != null) {
            this.myRenderHelper.setFile(newFile, null, null);
            if (newFile == null && this.previewArea != null) {
                this.previewArea.clear("Nothing to show");
            }
        }
        if (newFile != null) {
            this.currentFile = newFile;
            this.currentFilePath = FileUtil.toSystemDependentName((String)this.currentFile.getPath());
            this.flutterAnalysisServer.addOutlineListener(this.currentFilePath, this.outlineListener);
        }
    }

    private void setSelectedEditor(FileEditor newEditor) {
        if (this.currentEditor != null) {
            this.currentEditor.getCaretModel().removeCaretListener(this.caretListener);
        }
        if (newEditor instanceof TextEditor) {
            this.currentFileEditor = newEditor;
            this.currentEditor = ((TextEditor)newEditor).getEditor();
            this.currentEditor.getCaretModel().addCaretListener(this.caretListener);
        }
    }

    private void applyEditorSelectionToTree(Caret caret) {
        FlutterOutline outline;
        ArrayList<FlutterOutline> selectedOutlines = new ArrayList<FlutterOutline>();
        this.addOutlinesCoveredByRange(selectedOutlines, caret.getSelectionStart(), caret.getSelectionEnd(), this.currentOutline);
        if (selectedOutlines.isEmpty() && (outline = this.findOutlineAtOffset(this.currentOutline, caret.getOffset())) != null) {
            selectedOutlines.add(outline);
        }
        this.updateActionsForOutlines(selectedOutlines);
        this.applyOutlinesSelectionToTree(selectedOutlines);
        if (this.myRenderHelper != null) {
            int offset = caret.getOffset();
            this.myRenderHelper.setOffset(offset);
            this.previewArea.select(selectedOutlines);
        }
    }

    private void applyOutlinesSelectionToTree(List<FlutterOutline> outlines) {
        ArrayList<TreePath> selectedPaths = new ArrayList<TreePath>();
        Object[] lastNodePath = null;
        TreePath lastTreePath = null;
        for (FlutterOutline outline : outlines) {
            DefaultMutableTreeNode selectedNode = this.outlineToNodeMap.get(outline);
            if (selectedNode == null) continue;
            lastNodePath = selectedNode.getPath();
            lastTreePath = new TreePath(lastNodePath);
            selectedPaths.add(lastTreePath);
        }
        if (lastNodePath != null) {
            this.tree.scrollPathToVisible(lastTreePath);
            if (lastNodePath.length >= 2) {
                this.scrollTreeToNodeOnTop((TreeNode)lastNodePath[1]);
            }
            this.tree.scrollPathToVisible(lastTreePath);
        }
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.setSelectionPaths(selectedPaths.toArray(new TreePath[0]));
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.scrollPane.getHorizontalScrollBar().setValue(0);
    }

    private void scrollTreeToNodeOnTop(TreeNode node) {
        DefaultMutableTreeNode defaultNode;
        Rectangle bounds;
        if (node instanceof DefaultMutableTreeNode && (bounds = this.tree.getPathBounds(new TreePath((defaultNode = (DefaultMutableTreeNode)node).getPath()))) != null) {
            bounds.height = this.tree.getVisibleRect().height;
            this.tree.scrollRectToVisible(bounds);
        }
    }

    private void setSplitterProportion(float value) {
        this.isSettingSplitterProportion = true;
        try {
            this.splitter.setProportion(value);
        }
        finally {
            this.isSettingSplitterProportion = false;
        }
        PreviewView.doLayoutRecursively((Component)this.splitter);
    }

    private static void doLayoutRecursively(Component component) {
        if (component != null) {
            component.doLayout();
            if (component instanceof Container) {
                Container container = (Container)component;
                for (Component child : container.getComponents()) {
                    PreviewView.doLayoutRecursively(child);
                }
            }
        }
    }

    private void showNotRenderableInPreviewArea(@NotNull FlutterOutline widget) {
        if (widget == null) {
            PreviewView.$$$reportNull$$$0(8);
        }
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow, center]", "[grow, bottom][grow 200, top]"));
        panel.add((Component)new JBLabel("Selection is not a renderable widget"), "cell 0 0");
        LinkLabel linkLabel = LinkLabel.create((String)"Add forDesignTime() constructor...", () -> {
            SourceChange change;
            if (widget == null) {
                PreviewView.$$$reportNull$$$0(14);
            }
            if ((change = this.flutterAnalysisServer.flutter_getChangeAddForDesignTimeConstructor(this.currentFile, widget.getOffset())) != null) {
                this.applyChangeAndShowException(change);
            }
        });
        panel.add((Component)linkLabel, "cell 0 1");
        this.previewArea.clear(panel);
        this.minimizePreviewArea();
    }

    private void showLocalException(@NotNull Throwable localException) {
        if (localException == null) {
            PreviewView.$$$reportNull$$$0(9);
        }
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow, center]", "[grow, bottom][grow 200, top]"));
        panel.add((Component)new JBLabel("Encountered an exception during rendering"), "cell 0 0");
        LinkLabel linkLabel = LinkLabel.create((String)"Show exception...", () -> {
            if (localException == null) {
                PreviewView.$$$reportNull$$$0(13);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(localException.getMessage());
            localException.printStackTrace(printWriter);
            Module module = this.currentFile == null ? null : ModuleUtil.findModuleForFile((VirtualFile)this.currentFile, (Project)this.project);
            FlutterConsoles.displayMessage(this.project, module, stringWriter.toString().trim(), true);
        });
        panel.add((Component)linkLabel, "cell 0 1");
        this.previewArea.clear(panel);
    }

    private void showRemoteException(@NotNull JsonObject remoteException) {
        if (remoteException == null) {
            PreviewView.$$$reportNull$$$0(10);
        }
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow, center]", "[grow, bottom][grow 200, top]"));
        panel.add((Component)new JBLabel("Encountered an exception during rendering"), "cell 0 0");
        LinkLabel linkLabel = LinkLabel.create((String)"Show exception...", () -> {
            if (remoteException == null) {
                PreviewView.$$$reportNull$$$0(12);
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.println(remoteException.get("exception").getAsString());
            printWriter.println(remoteException.get("stackTrace").getAsString());
            Module module = this.currentFile == null ? null : ModuleUtil.findModuleForFile((VirtualFile)this.currentFile, (Project)this.project);
            FlutterConsoles.displayMessage(this.project, module, stringWriter.toString().trim(), true);
        });
        panel.add((Component)linkLabel, "cell 0 1");
        this.previewArea.clear(panel);
    }

    private void applyChangeAndShowException(SourceChange change) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                AssistUtils.applySourceChange((Project)this.project, (SourceChange)change, (boolean)false);
            }
            catch (DartSourceEditException exception) {
                FlutterMessages.showError("Error applying change", exception.getMessage());
            }
        });
    }

    private void sendAnalyticEvent(@NotNull String name) {
        if (name == null) {
            PreviewView.$$$reportNull$$$0(11);
        }
        FlutterInitializer.getAnalytics().sendEvent("preview", name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/preview/PreviewView";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outlines";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localException";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteException";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/preview/PreviewView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutlinesSelectedInTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateOutline";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateOutlineImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showNotRenderableInPreviewArea";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showLocalException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showRemoteException";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "sendAnalyticEvent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showRemoteException$6";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showLocalException$5";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showNotRenderableInPreviewArea$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ShowOnlyWidgetsAction
    extends AnAction
    implements Toggleable,
    RightAlignedToolbarAction {
        ShowOnlyWidgetsAction(@NotNull Icon icon, String text) {
            if (icon == null) {
                ShowOnlyWidgetsAction.$$$reportNull$$$0(0);
            }
            if (text == null) {
                ShowOnlyWidgetsAction.$$$reportNull$$$0(1);
            }
            super(text, null, icon);
        }

        public void actionPerformed(AnActionEvent e) {
            FlutterSettings flutterSettings;
            flutterSettings.setShowOnlyWidgets(!(flutterSettings = FlutterSettings.getInstance()).isShowOnlyWidgets());
            if (PreviewView.this.currentOutline != null) {
                PreviewView.this.updateOutline(PreviewView.this.currentOutline);
            }
        }

        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.putClientProperty("selected", (Object)FlutterSettings.getInstance().isShowOnlyWidgets());
            presentation.setEnabled(PreviewView.this.currentOutline != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
            }
            objectArray[1] = "io/flutter/preview/PreviewView$ShowOnlyWidgetsAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ExtractMethodAction
    extends AnAction {
        private final String id = "dart.assist.flutter.extractMethod";

        ExtractMethodAction() {
            super("Extract method...", null, FlutterIcons.ExtractMethod);
            this.id = "dart.assist.flutter.extractMethod";
        }

        public void actionPerformed(AnActionEvent e) {
            FlutterOutline outline;
            AnAction action = ActionManager.getInstance().getAction("ExtractMethod");
            if (action != null && (outline = this.getWidgetOutline()) != null) {
                TransactionGuard.submitTransaction((Disposable)PreviewView.this.project, () -> {
                    int offset = PreviewView.this.getConvertedOutlineOffset(outline);
                    int end = PreviewView.this.getConvertedOutlineEnd(outline);
                    PreviewView.this.currentEditor.getSelectionModel().setSelection(offset, end);
                    JComponent editorComponent = PreviewView.this.currentEditor.getComponent();
                    DataContext editorContext = DataManager.getInstance().getDataContext((Component)editorComponent);
                    AnActionEvent editorEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)editorContext);
                    action.actionPerformed(editorEvent);
                });
            }
        }

        public void update(AnActionEvent e) {
            boolean isEnabled = this.isEnabled();
            e.getPresentation().setEnabled(isEnabled);
        }

        boolean isEnabled() {
            return this.getWidgetOutline() != null;
        }

        private FlutterOutline getWidgetOutline() {
            FlutterOutline outline;
            List outlines = PreviewView.this.getOutlinesSelectedInTree();
            if (outlines.size() == 1 && (outline = (FlutterOutline)outlines.get(0)).getDartElement() == null) {
                return outline;
            }
            return null;
        }
    }

    private class QuickAssistAction
    extends AnAction {
        private final String id;

        QuickAssistAction(String id, Icon icon, String assistMessage) {
            if (id == null) {
                QuickAssistAction.$$$reportNull$$$0(0);
            }
            super(assistMessage, null, icon);
            this.id = id;
            PreviewView.this.messageToActionMap.put(assistMessage, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(AnActionEvent e) {
            SourceChange change;
            PreviewView.this.sendAnalyticEvent(this.id);
            Map map = PreviewView.this.actionToChangeMap;
            synchronized (map) {
                change = (SourceChange)PreviewView.this.actionToChangeMap.get((Object)this);
                PreviewView.this.actionToChangeMap.clear();
            }
            if (change != null) {
                PreviewView.this.applyChangeAndShowException(change);
            }
        }

        public void update(AnActionEvent e) {
            boolean hasChange = PreviewView.this.actionToChangeMap.containsKey((Object)this);
            e.getPresentation().setEnabled(hasChange);
        }

        boolean isEnabled() {
            return PreviewView.this.actionToChangeMap.containsKey((Object)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "io/flutter/preview/PreviewView$QuickAssistAction", "<init>"));
        }
    }
}

