/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import io.flutter.preview.DropShadowBorder;
import io.flutter.preview.RenderObject;
import io.flutter.preview.SelectionEditPolicy;
import io.flutter.preview.TitleAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.jetbrains.annotations.NotNull;

public class PreviewArea {
    public static int BORDER_WIDTH = 0;
    public static final String NOTHING_TO_SHOW = "Nothing to show";
    public static final String NO_WIDGET_MESSAGE = "No widget selected";
    public static final String NOT_RENDERABLE = "Selection is not a renderable widget";
    private static final Color[] widgetColors = new Color[]{new JBColor(new Color(12120575), new Color(5533306)), new JBColor(new Color(8454130), new Color(35189)), new JBColor(new Color(0xE1E1E1), new Color(0x757575)), new JBColor(new Color(8444927), new Color(166097)), new JBColor(new Color(10551242), new Color(6323595)), new JBColor(new Color(16765109), new Color(9268835))};
    private static final Color labelColor = new JBColor(new Color(0x333333), new Color(0xCCCCCC));
    private final Listener myListener;
    private final DefaultActionGroup toolbarGroup = new DefaultActionGroup();
    private final ActionToolbar windowToolbar;
    private final SimpleToolWindowPanel window;
    private final JLayeredPane layeredPanel = new JLayeredPane();
    private final JPanel primaryLayer = new JPanel();
    private final JPanel handleLayer = new JPanel(null);
    private boolean isBeingRendered = false;
    private final Map<Integer, FlutterOutline> idToOutline = new HashMap<Integer, FlutterOutline>();
    private int rootWidgetId;
    private RenderObject rootRenderObject;
    private final Map<Integer, RenderObject> idToRenderObject = new HashMap<Integer, RenderObject>();
    private final Map<FlutterOutline, JComponent> outlineToComponent = new HashMap<FlutterOutline, JComponent>();
    private final List<SelectionEditPolicy> selectionComponents = new ArrayList<SelectionEditPolicy>();
    private int widgetIndex = 0;

    public PreviewArea(final Listener listener) {
        this.myListener = listener;
        this.windowToolbar = ActionManager.getInstance().createActionToolbar("PreviewArea", (ActionGroup)this.toolbarGroup, true);
        this.window = new SimpleToolWindowPanel(true, true);
        this.window.setToolbar(this.windowToolbar.getComponent());
        this.primaryLayer.setLayout(new BorderLayout());
        this.clear(NO_WIDGET_MESSAGE);
        this.handleLayer.setOpaque(false);
        this.window.setContent((JComponent)this.layeredPanel);
        this.layeredPanel.add((Component)this.primaryLayer, (Object)0);
        this.layeredPanel.add((Component)this.handleLayer, (Object)1);
        this.layeredPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension renderSize = PreviewArea.this.getRenderSize();
                listener.resized(renderSize.width, renderSize.height);
            }
        });
    }

    public JComponent getComponent() {
        return this.window;
    }

    public void clear(String message) {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[grow, center]", "[grow][][grow 200]"));
        panel.add((Component)new JBLabel(message, 0), "cell 0 1");
        this.clear(panel);
    }

    public void clear(JComponent component) {
        this.setToolbarTitle(null);
        this.rootWidgetId = 0;
        this.rootRenderObject = null;
        this.idToRenderObject.clear();
        this.idToOutline.clear();
        this.outlineToComponent.clear();
        this.primaryLayer.removeAll();
        this.primaryLayer.setLayout(new BorderLayout());
        this.primaryLayer.add((Component)component, "Center");
        this.handleLayer.removeAll();
        this.window.revalidate();
        this.window.repaint();
    }

    public void renderingStarted() {
        this.isBeingRendered = true;
    }

    public void show(@NotNull FlutterOutline unitOutline, @NotNull FlutterOutline widgetOutline, @NotNull JsonObject renderObject) {
        if (unitOutline == null) {
            PreviewArea.$$$reportNull$$$0(0);
        }
        if (widgetOutline == null) {
            PreviewArea.$$$reportNull$$$0(1);
        }
        if (renderObject == null) {
            PreviewArea.$$$reportNull$$$0(2);
        }
        this.isBeingRendered = false;
        this.idToOutline.clear();
        this.fillIdToOutline(unitOutline);
        this.fillIdToRenderObject(renderObject);
        this.primaryLayer.removeAll();
        this.primaryLayer.setLayout(null);
        FlutterOutline rootOutline = this.idToOutline.get(this.rootWidgetId);
        if (rootOutline == null) {
            this.clear(NO_WIDGET_MESSAGE);
            return;
        }
        Element widgetClassElement = widgetOutline.getDartElement();
        if (widgetClassElement != null) {
            String widgetClassName = widgetClassElement.getName();
            String stateClassName = widgetOutline.getStateClassName();
            String title = widgetClassName + (stateClassName != null ? " > " + stateClassName : "");
            this.setToolbarTitle(title);
        } else {
            this.setToolbarTitle(null);
        }
        this.outlineToComponent.clear();
        this.widgetIndex = 0;
        this.renderWidgetOutline(rootOutline);
        this.window.revalidate();
        this.window.repaint();
    }

    public void select(@NotNull List<FlutterOutline> outlines) {
        if (outlines == null) {
            PreviewArea.$$$reportNull$$$0(3);
        }
        if (this.isBeingRendered) {
            return;
        }
        for (SelectionEditPolicy policy : this.selectionComponents) {
            policy.deactivate();
        }
        this.selectionComponents.clear();
        for (FlutterOutline outline : outlines) {
            JComponent widget = this.outlineToComponent.get(outline);
            if (widget == null) continue;
            SelectionEditPolicy selectionPolicy = new SelectionEditPolicy(this.handleLayer, widget);
            this.selectionComponents.add(selectionPolicy);
            selectionPolicy.activate();
        }
        this.primaryLayer.repaint();
    }

    private void fillIdToOutline(@NotNull FlutterOutline outline) {
        if (outline == null) {
            PreviewArea.$$$reportNull$$$0(4);
        }
        if (outline.getId() != null) {
            this.idToOutline.put(outline.getId(), outline);
        }
        if (outline.getChildren() != null) {
            for (FlutterOutline child : outline.getChildren()) {
                this.fillIdToOutline(child);
            }
        }
    }

    private void fillIdToRenderObject(@NotNull JsonObject renderJson) {
        if (renderJson == null) {
            PreviewArea.$$$reportNull$$$0(5);
        }
        this.rootRenderObject = null;
        this.idToRenderObject.clear();
        for (Map.Entry entry : renderJson.entrySet()) {
            try {
                int id = Integer.parseInt((String)entry.getKey());
                JsonObject widgetObject = (JsonObject)entry.getValue();
                JsonObject boundsObject = widgetObject.getAsJsonObject("globalBounds");
                int left = boundsObject.getAsJsonPrimitive("left").getAsInt();
                int top = boundsObject.getAsJsonPrimitive("top").getAsInt();
                int width = boundsObject.getAsJsonPrimitive("width").getAsInt();
                int height = boundsObject.getAsJsonPrimitive("height").getAsInt();
                Rectangle rect = new Rectangle(left, top, width, height);
                RenderObject renderObject = new RenderObject(rect);
                if (this.rootRenderObject == null) {
                    this.rootWidgetId = id;
                    this.rootRenderObject = renderObject;
                }
                this.idToRenderObject.put(id, renderObject);
            }
            catch (Throwable throwable) {}
        }
    }

    private void renderWidgetOutline(final @NotNull FlutterOutline outline) {
        Integer id;
        if (outline == null) {
            PreviewArea.$$$reportNull$$$0(6);
        }
        if ((id = outline.getId()) == null) {
            return;
        }
        RenderObject renderObject = this.idToRenderObject.get(id);
        if (renderObject == null) {
            return;
        }
        Rectangle rect = renderObject.globalBounds;
        int x = BORDER_WIDTH + rect.x - this.rootRenderObject.globalBounds.x;
        int y = BORDER_WIDTH + rect.y - this.rootRenderObject.globalBounds.y;
        JPanel widget = new JPanel(new BorderLayout());
        DropShadowBorder shadowBorder = new DropShadowBorder();
        widget.setBorder(shadowBorder);
        widget.setOpaque(false);
        Insets insets = shadowBorder.getBorderInsets(widget);
        widget.setBounds(new Rectangle(x, y, rect.width + insets.right, rect.height + insets.bottom));
        JPanel inner = new JPanel(new BorderLayout());
        inner.setBackground(widgetColors[this.widgetIndex % widgetColors.length]);
        ++this.widgetIndex;
        inner.setBorder(BorderFactory.createLineBorder(inner.getBackground().darker()));
        widget.add((Component)inner, "Center");
        JBLabel label = new JBLabel(outline.getClassName());
        label.setBorder((Border)JBUI.Borders.empty((int)1, (int)4, (int)0, (int)0));
        label.setForeground(labelColor);
        inner.add((Component)label, "North");
        this.outlineToComponent.put(outline, widget);
        inner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    PreviewArea.this.myListener.doubleClicked(outline);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PreviewArea.this.myListener.clicked(outline);
            }
        });
        List<FlutterOutline> children = outline.getChildren();
        if (children != null) {
            for (FlutterOutline child : Lists.reverse(children)) {
                this.renderWidgetOutline(child);
            }
        }
        this.primaryLayer.add(widget);
    }

    private void setToolbarTitle(String text) {
        this.toolbarGroup.removeAll();
        this.toolbarGroup.add((AnAction)new TitleAction(text == null ? "Preview" : "Preview: " + text));
        this.windowToolbar.updateActionsImmediately();
    }

    public Dimension getRenderSize() {
        int width = this.layeredPanel.getWidth();
        int height = this.layeredPanel.getHeight();
        for (Component child : this.layeredPanel.getComponents()) {
            child.setBounds(0, 0, width, height);
        }
        int renderWidth = width - 2 * BORDER_WIDTH;
        int renderHeight = height - 2 * BORDER_WIDTH;
        return new Dimension(renderWidth, renderHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitOutline";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetOutline";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderObject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outlines";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outline";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderJson";
                break;
            }
        }
        objectArray2[1] = "io/flutter/preview/PreviewArea";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillIdToOutline";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fillIdToRenderObject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "renderWidgetOutline";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface Listener {
        public void clicked(FlutterOutline var1);

        public void doubleClicked(FlutterOutline var1);

        public void resized(int var1, int var2);
    }
}

