/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.preview;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import io.flutter.preview.DartElementPresentationUtil;
import io.flutter.preview.ModelUtils;
import io.flutter.preview.OutlineObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.FlutterOutlineAttribute;
import org.jetbrains.annotations.NotNull;

class OutlineTreeCellRenderer
extends ColoredTreeCellRenderer {
    private JTree tree;
    private boolean selected;

    OutlineTreeCellRenderer() {
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        List<FlutterOutlineAttribute> attributes;
        Object userObject;
        if (tree == null) {
            OutlineTreeCellRenderer.$$$reportNull$$$0(0);
        }
        if (!((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof OutlineObject)) {
            return;
        }
        OutlineObject node = (OutlineObject)userObject;
        FlutterOutline outline = node.outline;
        this.tree = tree;
        this.selected = selected;
        Element dartElement = outline.getDartElement();
        if (dartElement != null) {
            Icon icon = DartElementPresentationUtil.getIcon(dartElement);
            this.setIcon(icon);
            boolean renderInBold = this.hasWidgetChild(outline) && ModelUtils.isBuildMethod(dartElement);
            DartElementPresentationUtil.renderElement(dartElement, this, renderInBold);
            return;
        }
        Icon icon = node.getFlutterDecoratedIcon();
        if (icon != null) {
            this.setIcon(icon);
        }
        this.appendSearch(outline.getClassName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (outline.getVariableName() != null) {
            this.append(" ");
            this.appendSearch(outline.getVariableName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (outline.getKind().equals("GENERIC") && outline.getLabel() != null) {
            this.append(" ");
            String label = outline.getLabel();
            this.appendSearch(label, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if ((attributes = outline.getAttributes()) != null) {
            if (attributes.size() == 1 && OutlineTreeCellRenderer.isAttributeElidable(attributes.get(0).getName())) {
                FlutterOutlineAttribute attribute = attributes.get(0);
                this.append(" ");
                this.appendSearch(attribute.getLabel(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            } else {
                for (int i = 0; i < attributes.size(); ++i) {
                    FlutterOutlineAttribute attribute = attributes.get(i);
                    if (i > 0) {
                        this.append(",");
                    }
                    this.append(" ");
                    if (!StringUtil.equals((CharSequence)"data", (CharSequence)attribute.getName())) {
                        this.appendSearch(attribute.getName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append(": ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    this.appendSearch(attribute.getLabel(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    private boolean hasWidgetChild(FlutterOutline outline) {
        if (outline.getChildren() == null) {
            return false;
        }
        for (FlutterOutline child : outline.getChildren()) {
            if (child.getDartElement() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttributeElidable(String name) {
        return StringUtil.equals((CharSequence)"text", (CharSequence)name) || StringUtil.equals((CharSequence)"icon", (CharSequence)name);
    }

    void appendSearch(@NotNull String text, @NotNull SimpleTextAttributes attributes) {
        if (text == null) {
            OutlineTreeCellRenderer.$$$reportNull$$$0(1);
        }
        if (attributes == null) {
            OutlineTreeCellRenderer.$$$reportNull$$$0(2);
        }
        SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)this.tree, (String)text, (SimpleTextAttributes)attributes, (boolean)this.selected, (SimpleColoredComponent)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
        }
        objectArray2[1] = "io/flutter/preview/OutlineTreeCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeCellRenderer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSearch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

