/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import io.flutter.perf.FlutterFramesMonitor;
import io.flutter.perf.HeapMonitor;
import io.flutter.run.FlutterDebugProcess;
import io.flutter.server.vmService.VmServiceConsumers;
import io.flutter.utils.EventStream;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.NotNull;

public class PerfService {
    @NotNull
    private final HeapMonitor heapMonitor;
    @NotNull
    private final FlutterFramesMonitor flutterFramesMonitor;
    @NotNull
    private final Map<String, EventStream<Boolean>> serviceExtensions;
    private final EventStream<IsolateRef> flutterIsolateRefStream;
    private boolean isRunning;

    public PerfService(@NotNull FlutterDebugProcess debugProcess, final @NotNull VmService vmService) {
        if (debugProcess == null) {
            PerfService.$$$reportNull$$$0(0);
        }
        if (vmService == null) {
            PerfService.$$$reportNull$$$0(1);
        }
        this.serviceExtensions = new THashMap();
        this.heapMonitor = new HeapMonitor(vmService, debugProcess);
        this.flutterFramesMonitor = new FlutterFramesMonitor(vmService);
        this.flutterIsolateRefStream = new EventStream();
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                PerfService.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
                PerfService.this.onVmConnectionClosed();
            }
        });
        vmService.streamListen("Isolate", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen("Extension", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.streamListen("GC", VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
        vmService.getVM(new VMConsumer(){

            @Override
            public void received(VM vm) {
                for (final IsolateRef isolateRef : vm.getIsolates()) {
                    vmService.getIsolate(isolateRef.getId(), new GetIsolateConsumer(){

                        @Override
                        public void onError(RPCError error) {
                        }

                        @Override
                        public void received(Isolate isolate) {
                            if (PerfService.this.flutterIsolateRefStream.getValue() == null) {
                                for (String extensionName : isolate.getExtensionRPCs()) {
                                    if (!extensionName.startsWith("ext.flutter.")) continue;
                                    PerfService.this.setFlutterIsolate(isolateRef);
                                    break;
                                }
                            }
                            ApplicationManager.getApplication().invokeLater(() -> {
                                for (String extension : isolate.getExtensionRPCs()) {
                                    PerfService.this.addServiceExtension(extension);
                                }
                            });
                        }

                        @Override
                        public void received(Sentinel sentinel) {
                        }
                    });
                }
            }

            @Override
            public void onError(RPCError error) {
            }
        });
    }

    public void start() {
        if (!this.isRunning) {
            this.heapMonitor.start();
            this.isRunning = true;
        }
    }

    public StreamSubscription<IsolateRef> getCurrentFlutterIsolate(Consumer<IsolateRef> onValue, boolean onUIThread) {
        return this.flutterIsolateRefStream.listen(onValue, onUIThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IsolateRef getCurrentFlutterIsolateRaw() {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            return this.flutterIsolateRefStream.getValue();
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.heapMonitor.stop();
        }
    }

    private void onVmConnectionClosed() {
        if (this.isRunning) {
            this.heapMonitor.stop();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFlutterIsolate(IsolateRef ref) {
        EventStream<IsolateRef> eventStream = this.flutterIsolateRefStream;
        synchronized (eventStream) {
            IsolateRef existing = this.flutterIsolateRefStream.getValue();
            if (existing == ref || existing != null && ref != null && StringUtil.equals((CharSequence)existing.getId(), (CharSequence)ref.getId())) {
                return;
            }
            this.flutterIsolateRefStream.setValue(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVmServiceReceived(String streamId, Event event) {
        IsolateRef flutterIsolateRef = this.flutterIsolateRefStream.getValue();
        if (flutterIsolateRef != null && event.getKind() == EventKind.IsolateExit && StringUtil.equals((CharSequence)event.getIsolate().getId(), (CharSequence)flutterIsolateRef.getId())) {
            ArrayList<EventStream<Boolean>> existingExtensions;
            this.setFlutterIsolate(null);
            Map<String, EventStream<Boolean>> map = this.serviceExtensions;
            synchronized (map) {
                existingExtensions = new ArrayList<EventStream<Boolean>>(this.serviceExtensions.values());
            }
            for (EventStream eventStream : existingExtensions) {
                eventStream.setValue(false);
            }
        }
        if (event.getKind() == EventKind.ServiceExtensionAdded) {
            this.addServiceExtension(event.getExtensionRPC());
        }
        if (this.flutterIsolateRefStream.getValue() == null) {
            String extensionName;
            if (event.getKind() == EventKind.Extension && event.getExtensionKind().startsWith("Flutter.")) {
                this.setFlutterIsolate(event.getIsolate());
            }
            if (event.getKind() == EventKind.ServiceExtensionAdded && (extensionName = event.getExtensionRPC()).startsWith("ext.flutter.")) {
                this.setFlutterIsolate(event.getIsolate());
            }
        }
        if (!this.isRunning) {
            return;
        }
        if (StringUtil.equals((CharSequence)streamId, (CharSequence)"GC")) {
            IsolateRef isolateRef = event.getIsolate();
            HeapMonitor.HeapSpace newHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("new"));
            HeapMonitor.HeapSpace heapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("old"));
            this.heapMonitor.handleGCEvent(isolateRef, newHeapSpace, heapSpace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceExtension(String name) {
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            EventStream<Boolean> stream = this.serviceExtensions.get(name);
            if (stream == null) {
                this.serviceExtensions.put(name, new EventStream<Boolean>(true));
            } else if (!stream.getValue().booleanValue()) {
                stream.setValue(true);
            }
        }
    }

    @NotNull
    public FlutterFramesMonitor getFlutterFramesMonitor() {
        FlutterFramesMonitor flutterFramesMonitor = this.flutterFramesMonitor;
        if (flutterFramesMonitor == null) {
            PerfService.$$$reportNull$$$0(2);
        }
        return flutterFramesMonitor;
    }

    public void addHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            PerfService.$$$reportNull$$$0(3);
        }
        boolean hadListeners = this.heapMonitor.hasListeners();
        this.heapMonitor.addListener(listener);
        if (!hadListeners) {
            this.start();
        }
    }

    public void removeHeapListener(@NotNull HeapMonitor.HeapListener listener) {
        if (listener == null) {
            PerfService.$$$reportNull$$$0(4);
        }
        this.heapMonitor.removeListener(listener);
        if (!this.heapMonitor.hasListeners()) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public StreamSubscription<Boolean> hasServiceExtension(String name, Consumer<Boolean> onData) {
        EventStream<Boolean> stream;
        Map<String, EventStream<Boolean>> map = this.serviceExtensions;
        synchronized (map) {
            stream = this.serviceExtensions.get(name);
            if (stream == null) {
                stream = new EventStream<Boolean>(false);
                this.serviceExtensions.put(name, stream);
            }
        }
        StreamSubscription<Boolean> streamSubscription = stream.listen(onData, true);
        if (streamSubscription == null) {
            PerfService.$$$reportNull$$$0(5);
        }
        return streamSubscription;
    }

    public void pausePolling() {
        if (this.isRunning) {
            this.heapMonitor.pausePolling();
        }
    }

    public void resumePolling() {
        if (this.isRunning) {
            this.heapMonitor.resumePolling();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/perf/PerfService";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/perf/PerfService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterFramesMonitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "hasServiceExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addHeapListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeHeapListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

