/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.diagnostic.Logger;
import io.flutter.run.FlutterDebugProcess;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.consumer.GetIsolateConsumer;
import org.dartlang.vm.service.consumer.VMConsumer;
import org.dartlang.vm.service.element.ElementList;
import org.dartlang.vm.service.element.Isolate;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.Obj;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.Sentinel;
import org.dartlang.vm.service.element.VM;
import org.jetbrains.annotations.NotNull;

public class HeapMonitor {
    private static final Logger LOG = Logger.getInstance(HeapMonitor.class);
    private static final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
    private static final int POLL_PERIOD_IN_MS = 1000;
    private final List<HeapListener> heapListeners;
    private ScheduledFuture pollingScheduler;
    @NotNull
    private final VmService vmService;
    private boolean isPolling;

    public HeapMonitor(@NotNull VmService vmService, @NotNull FlutterDebugProcess debugProcess) {
        if (vmService == null) {
            HeapMonitor.$$$reportNull$$$0(0);
        }
        if (debugProcess == null) {
            HeapMonitor.$$$reportNull$$$0(1);
        }
        this.heapListeners = new ArrayList<HeapListener>();
        this.vmService = vmService;
    }

    public void addListener(@NotNull HeapListener listener) {
        if (listener == null) {
            HeapMonitor.$$$reportNull$$$0(2);
        }
        this.heapListeners.add(listener);
    }

    public void removeListener(@NotNull HeapListener listener) {
        if (listener == null) {
            HeapMonitor.$$$reportNull$$$0(3);
        }
        this.heapListeners.add(listener);
    }

    public boolean hasListeners() {
        return !this.heapListeners.isEmpty();
    }

    void start() {
        this.isPolling = true;
        this.pollingScheduler = executor.scheduleAtFixedRate(this::poll, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void pausePolling() {
        this.isPolling = false;
    }

    public void resumePolling() {
        this.isPolling = true;
    }

    private void poll() {
        if (!this.isPolling) {
            return;
        }
        this.vmService.getVM(new VMConsumer(){

            @Override
            public void received(VM vm) {
                HeapMonitor.this.collectIsolateInfo(vm);
            }

            @Override
            public void onError(RPCError error) {
            }
        });
    }

    private void collectIsolateInfo(final VM vm) {
        ElementList<IsolateRef> isolateRefs = vm.getIsolates();
        final int isolateCount = isolateRefs.size();
        final ArrayList isolates = new ArrayList();
        for (IsolateRef isolateRef : isolateRefs) {
            this.vmService.getIsolate(isolateRef.getId(), new GetIsolateConsumer(){

                @Override
                public void received(Isolate isolateResponse) {
                    isolates.add(new IsolateObject(isolateResponse.getJson()));
                    if (isolates.size() == isolateCount) {
                        HeapMonitor.this.notifyListeners(vm, isolates);
                    }
                }

                @Override
                public void received(Sentinel sentinel) {
                }

                @Override
                public void onError(RPCError error) {
                }
            });
        }
    }

    void handleGCEvent(IsolateRef isolateRef, HeapSpace newHeapSpace, HeapSpace oldHeapSpace) {
        this.heapListeners.forEach(listener -> listener.handleGCEvent(isolateRef, newHeapSpace, oldHeapSpace));
    }

    private void notifyListeners(VM vm, List<IsolateObject> isolates) {
        this.heapListeners.forEach(listener -> listener.handleIsolatesInfo(vm, isolates));
    }

    void stop() {
        if (this.pollingScheduler != null) {
            this.pollingScheduler.cancel(false);
            this.pollingScheduler = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "io/flutter/perf/HeapMonitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class HeapSample {
        final int bytes;
        final boolean isGC;
        public final long sampleTime;

        public long getSampleTime() {
            return this.sampleTime;
        }

        public HeapSample(int bytes, boolean isGC) {
            this.bytes = bytes;
            this.isGC = isGC;
            this.sampleTime = System.currentTimeMillis();
        }

        public int getBytes() {
            return this.bytes;
        }

        public String toString() {
            return "bytes: " + this.bytes + (this.isGC ? " (GC)" : "");
        }
    }

    public static class IsolateObject
    extends HeapObject {
        IsolateObject(@NotNull JsonObject json) {
            if (json == null) {
                IsolateObject.$$$reportNull$$$0(0);
            }
            super(json);
        }

        public List<HeapSpace> getHeaps() {
            ArrayList<HeapSpace> heaps = new ArrayList<HeapSpace>();
            for (Map.Entry<String, JsonElement> entry : this.getEntries("_heaps")) {
                heaps.add(new HeapSpace(entry.getValue().getAsJsonObject()));
            }
            return heaps;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "io/flutter/perf/HeapMonitor$IsolateObject", "<init>"));
        }
    }

    public static class HeapSpace
    extends HeapObject {
        public HeapSpace(@NotNull JsonObject json) {
            if (json == null) {
                HeapSpace.$$$reportNull$$$0(0);
            }
            super(json);
        }

        public int getUsed() {
            return this.getAsInt("used");
        }

        public int getCapacity() {
            return this.getAsInt("capacity");
        }

        public int getExternal() {
            return this.getAsInt("external");
        }

        public double getTime() {
            return this.json.get("time").getAsDouble();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "io/flutter/perf/HeapMonitor$HeapSpace", "<init>"));
        }
    }

    static class HeapObject
    extends Obj {
        HeapObject(@NotNull JsonObject json) {
            if (json == null) {
                HeapObject.$$$reportNull$$$0(0);
            }
            super(json);
        }

        int getAsInt(String memberName) {
            return this.json.get(memberName).getAsInt();
        }

        String getAsString(String memberName) {
            return this.json.get(memberName).getAsString();
        }

        JsonObject getAsJsonObject(String memberName) {
            return this.json.get(memberName).getAsJsonObject();
        }

        Set<Map.Entry<String, JsonElement>> getEntries(String memberName) {
            return this.getAsJsonObject(memberName).entrySet();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "json", "io/flutter/perf/HeapMonitor$HeapObject", "<init>"));
        }
    }

    public static interface HeapListener {
        public void handleIsolatesInfo(VM var1, List<IsolateObject> var2);

        public void handleGCEvent(IsolateRef var1, HeapSpace var2, HeapSpace var3);
    }
}

