/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.perf;

import com.google.gson.JsonObject;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import io.flutter.utils.VmServiceListenerAdapter;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.ExtensionData;
import org.jetbrains.annotations.NotNull;

public class FlutterFramesMonitor {
    public static final long microsPerFrame = 16666L;
    static final int maxFrames = 200;
    private final EventDispatcher<Listener> eventDispatcher;
    private long lastEventFinished;
    public List<FlutterFrameEvent> frames;

    FlutterFramesMonitor(@NotNull VmService vmService) {
        if (vmService == null) {
            FlutterFramesMonitor.$$$reportNull$$$0(0);
        }
        this.eventDispatcher = EventDispatcher.create(Listener.class);
        this.lastEventFinished = 0L;
        this.frames = new LinkedList<FlutterFrameEvent>();
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                FlutterFramesMonitor.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
            }
        });
    }

    private void onVmServiceReceived(String streamId, Event event) {
        if (StringUtil.equals((CharSequence)streamId, (CharSequence)"Extension") && StringUtil.equals((CharSequence)"Flutter.Frame", (CharSequence)event.getExtensionKind())) {
            this.handleFlutterFrame(event);
        }
    }

    public boolean hasFps() {
        return !this.frames.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getFPS() {
        int frameCount = 0;
        int costCount = 0;
        FlutterFramesMonitor flutterFramesMonitor = this;
        synchronized (flutterFramesMonitor) {
            for (FlutterFrameEvent frame : this.frames) {
                ++frameCount;
                long thisCost = frame.elapsedMicros / 16666L;
                if (frame.elapsedMicros > thisCost * 16666L) {
                    ++thisCost;
                }
                costCount = (int)((long)costCount + thisCost);
                if (!frame.frameSetStart) continue;
                break;
            }
        }
        if (costCount == 0) {
            return 0.0;
        }
        return (double)frameCount * 60.0 / (double)costCount;
    }

    public void addListener(Listener listener) {
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(Listener listener) {
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFlutterFrame(Event event) {
        FlutterFrameEvent frameEvent = new FlutterFrameEvent(event.getExtensionData(), this.lastEventFinished);
        this.lastEventFinished = frameEvent.getFrameFinishedMicros();
        FlutterFramesMonitor flutterFramesMonitor = this;
        synchronized (flutterFramesMonitor) {
            this.frames.add(0, frameEvent);
            if (this.frames.size() > 200) {
                this.frames.remove(this.frames.size() - 1);
            }
        }
        ((Listener)this.eventDispatcher.getMulticaster()).handleFrameEvent(frameEvent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vmService", "io/flutter/perf/FlutterFramesMonitor", "<init>"));
    }

    public static class FlutterFrameEvent {
        public final int frameId;
        public final long startTimeMicros;
        public final long elapsedMicros;
        public final boolean frameSetStart;

        FlutterFrameEvent(ExtensionData data, long lastEventFinished) {
            JsonObject json = data.getJson();
            this.frameId = json.get("number").getAsInt();
            this.startTimeMicros = json.get("startTime").getAsLong();
            this.elapsedMicros = json.get("elapsed").getAsLong();
            this.frameSetStart = this.startTimeMicros - lastEventFinished > 33332L;
        }

        public long getFrameFinishedMicros() {
            return this.startTimeMicros + this.elapsedMicros;
        }

        public boolean isSlowFrame() {
            return this.elapsedMicros > 16666L;
        }

        public int hashCode() {
            return this.frameId;
        }

        public boolean equals(Object other) {
            return other instanceof FlutterFrameEvent && ((FlutterFrameEvent)other).frameId == this.frameId;
        }

        public String toString() {
            return "#" + this.frameId + " " + this.elapsedMicros + "\u00b5s";
        }
    }

    public static interface Listener
    extends EventListener {
        public void handleFrameEvent(FlutterFrameEvent var1);
    }
}

