/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.WebProjectGenerator;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.dart.DartPlugin;
import io.flutter.module.FlutterSmallIDEGeneratorPeer;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.FlutterModuleUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlutterSmallIDEProjectGenerator
extends WebProjectTemplate<String> {
    private static final Logger LOG = Logger.getInstance(FlutterSmallIDEProjectGenerator.class);
    private FlutterSmallIDEGeneratorPeer generatorPeer;

    public static void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull String flutterSdkPath, @NotNull Module module, @NotNull FlutterCreateAdditionalSettings settings) {
        FlutterSdk sdk;
        if (project == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(1);
        }
        if (flutterSdkPath == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(4);
        }
        if ((sdk = FlutterSdk.forPath(flutterSdkPath)) == null) {
            FlutterMessages.showError("Error creating project", flutterSdkPath + " is not a valid Flutter SDK");
            return;
        }
        FlutterUtils.disableGradleProjectMigrationNotification(project);
        OutputListener listener = new OutputListener();
        PubRoot root = sdk.createFiles(baseDir, module, (ProcessListener)listener, settings);
        if (root == null) {
            String stderr = listener.getOutput().getStderr();
            String msg = stderr.isEmpty() ? "Flutter create command was unsuccessful" : stderr;
            FlutterMessages.showError("Error creating project", msg);
            return;
        }
        Runnable runnable = () -> {
            if (project == null) {
                FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(11);
            }
            if (module == null) {
                FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(12);
            }
            FlutterSmallIDEProjectGenerator.applyDartModule(sdk, project, module, root);
        };
        try {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable);
        }
        catch (ProcessCanceledException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void applyDartModule(FlutterSdk sdk, Project project, Module module, PubRoot root) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            String dartSdkPath = sdk.getDartSdkPath();
            if (dartSdkPath == null) {
                FlutterMessages.showError("Error creating project", "unable to get Dart SDK");
                return;
            }
            DartPlugin.ensureDartSdkConfigured(project, sdk.getDartSdkPath());
            DartPlugin.enableDartSdk(module);
            FlutterSdkUtil.updateKnownSdkPaths(sdk.getHomePath());
            ModifiableRootModel modifiableModel = ModifiableModelsProvider.SERVICE.getInstance().getModuleModifiableModel(module);
            modifiableModel.addContentEntry(root.getRoot());
            ModifiableModelsProvider.SERVICE.getInstance().commitModuleModifiableModel(modifiableModel);
            FlutterModuleUtils.autoShowMain(project, root);
        });
    }

    @NotNull
    public String getName() {
        String string = FlutterBundle.message("flutter.title", new Object[0]);
        if (string == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getDescription() {
        return FlutterBundle.message("flutter.project.description", new Object[0]);
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<String> createPeer() {
        FlutterSmallIDEGeneratorPeer flutterSmallIDEGeneratorPeer = this.generatorPeer = new FlutterSmallIDEGeneratorPeer();
        if (flutterSmallIDEGeneratorPeer == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(6);
        }
        return flutterSmallIDEGeneratorPeer;
    }

    public Icon getLogo() {
        return FlutterIcons.Flutter;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull String flutterSdkPath, @NotNull Module module) {
        if (project == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(8);
        }
        if (flutterSdkPath == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(9);
        }
        if (module == null) {
            FlutterSmallIDEProjectGenerator.$$$reportNull$$$0(10);
        }
        FlutterSmallIDEProjectGenerator.generateProject(project, baseDir, flutterSdkPath, module, this.generatorPeer.getAdditionalSettings());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterSdkPath";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/module/FlutterSmallIDEProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/module/FlutterSmallIDEProjectGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

