/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.module;

import com.intellij.execution.OutputListener;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.FlutterIcons;
import io.flutter.FlutterBundle;
import io.flutter.FlutterConstants;
import io.flutter.FlutterMessages;
import io.flutter.FlutterUtils;
import io.flutter.actions.FlutterDoctorAction;
import io.flutter.module.FlutterGeneratorPeer;
import io.flutter.module.settings.FlutterCreateAdditionalSettingsFields;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterCreateAdditionalSettings;
import io.flutter.sdk.FlutterSdk;
import io.flutter.sdk.FlutterSdkUtil;
import io.flutter.utils.FlutterModuleUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(FlutterModuleBuilder.class);
    private FlutterModuleWizardStep myStep;
    @NotNull
    private final FlutterCreateAdditionalSettingsFields mySettingsFields = new FlutterCreateAdditionalSettingsFields(new FlutterCreateAdditionalSettings());

    public String getName() {
        return this.getPresentableName();
    }

    public String getPresentableName() {
        return FlutterBundle.message("flutter.module.name", new Object[0]);
    }

    public String getDescription() {
        return FlutterBundle.message("flutter.project.description", new Object[0]);
    }

    public Icon getNodeIcon() {
        return FlutterIcons.Flutter;
    }

    public void setupRootModel(ModifiableRootModel model) {
        this.doAddContentEntry(model);
        model.addInvalidLibrary("Dart SDK", "project");
    }

    protected FlutterSdk getFlutterSdk() {
        return this.myStep.getFlutterSdk();
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        String basePath;
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(0);
        }
        if ((basePath = this.getModuleFileDirectory()) == null) {
            Messages.showErrorDialog((String)"Module path not set", (String)"Internal Error");
            return null;
        }
        VirtualFile baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(basePath);
        if (baseDir == null) {
            Messages.showErrorDialog((String)"Unable to determine Flutter project directory", (String)"Internal Error");
            return null;
        }
        FlutterSdk sdk = this.getFlutterSdk();
        if (sdk == null) {
            Messages.showErrorDialog((String)"Flutter SDK not found", (String)"Error");
            return null;
        }
        OutputListener listener = new OutputListener();
        PubRoot root = FlutterModuleBuilder.runFlutterCreateWithProgress(baseDir, sdk, project, (ProcessListener)listener, this.getAdditionalSettings());
        if (root == null) {
            String stderr = listener.getOutput().getStderr();
            String msg = stderr.isEmpty() ? "Flutter create command was unsuccessful" : stderr;
            int code = FlutterMessages.showDialog(project, msg, "Project Creation Error", new String[]{"Run Flutter Doctor", "Cancel"}, 0);
            if (code == 0) {
                new FlutterDoctorAction().startCommand(project, sdk, null);
            }
            return null;
        }
        FlutterSdkUtil.updateKnownSdkPaths(sdk.getHomePath());
        Module flutter = super.commitModule(project, model);
        if (flutter == null) {
            return null;
        }
        FlutterModuleUtils.autoShowMain(project, root);
        FlutterModuleBuilder.addAndroidModule(project, model, basePath, flutter.getName());
        return flutter;
    }

    private static String validateSettings(FlutterCreateAdditionalSettings settings) {
        String description = settings.getDescription();
        if (description != null && description.contains(": ")) {
            return "Invalid package description: '" + description + "' - cannot contain the sequence ': '.";
        }
        return null;
    }

    private static void addAndroidModule(@NotNull Project project, @Nullable ModifiableModuleModel model, @NotNull String baseDirPath, @NotNull String flutterModuleName) {
        VirtualFile baseDir;
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(1);
        }
        if (baseDirPath == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(2);
        }
        if (flutterModuleName == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(3);
        }
        if ((baseDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(baseDirPath)) == null) {
            return;
        }
        VirtualFile androidFile = FlutterModuleBuilder.findAndroidModuleFile(baseDir, flutterModuleName);
        if (androidFile == null) {
            return;
        }
        try {
            ModifiableModuleModel toCommit;
            if (model == null) {
                model = toCommit = ModuleManager.getInstance((Project)project).getModifiableModel();
            } else {
                toCommit = null;
            }
            model.loadModule(androidFile.getPath());
            if (toCommit != null) {
                WriteAction.run(() -> ((ModifiableModuleModel)toCommit).commit());
            }
        }
        catch (ModuleWithNameAlreadyExists | IOException e) {
            LOG.warn(e);
        }
    }

    @Nullable
    private static VirtualFile findAndroidModuleFile(@NotNull VirtualFile baseDir, String flutterModuleName) {
        if (baseDir == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(4);
        }
        baseDir.refresh(false, false);
        for (String name : Arrays.asList(flutterModuleName + "_android.iml", "android.iml")) {
            VirtualFile candidate = baseDir.findChild(name);
            if (candidate == null || !candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    public boolean validate(Project current, Project dest) {
        String settingsValidation = FlutterModuleBuilder.validateSettings(this.getAdditionalSettings());
        if (settingsValidation != null) {
            Messages.showErrorDialog((String)settingsValidation, (String)"Error");
            return false;
        }
        return this.myStep.getFlutterSdk() != null;
    }

    public boolean validateModuleName(@NotNull String moduleName) throws ConfigurationException {
        if (moduleName == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(5);
        }
        if (!FlutterUtils.isValidPackageName(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must be a valid Dart package name (lower_case_with_underscores).");
        }
        if (FlutterUtils.isDartKeyword(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must not be a Dart keyword.");
        }
        if (!FlutterUtils.isValidDartIdentifier(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - must be a valid Dart identifier.");
        }
        if (FlutterConstants.FLUTTER_PACKAGE_DEPENDENCIES.contains(moduleName)) {
            throw new ConfigurationException("Invalid module name: '" + moduleName + "' - this will conflict with Flutter package dependencies.");
        }
        if (moduleName.length() > 30) {
            throw new ConfigurationException("Invalid module name - must be less than 30 characters.");
        }
        return super.validateModuleName(moduleName);
    }

    @NotNull
    public FlutterCreateAdditionalSettings getAdditionalSettings() {
        FlutterCreateAdditionalSettings flutterCreateAdditionalSettings = this.mySettingsFields.getAdditionalSettings();
        if (flutterCreateAdditionalSettings == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(6);
        }
        return flutterCreateAdditionalSettings;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(7);
        }
        ModuleWizardStep wizard = super.modifySettingsStep(settingsStep);
        this.mySettingsFields.addSettingsFields(settingsStep);
        return wizard;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        this.myStep = new FlutterModuleWizardStep(context);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myStep);
        return this.myStep;
    }

    @NotNull
    public String getBuilderId() {
        String string = StringUtil.notNullize((String)super.getBuilderId()) + "_" + FlutterModuleBuilder.class.getCanonicalName();
        if (string == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = FlutterModuleUtils.getFlutterModuleType();
        if (moduleType == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(10);
        }
        return moduleType;
    }

    @Nullable
    private static PubRoot runFlutterCreateWithProgress(@NotNull VirtualFile baseDir, @NotNull FlutterSdk sdk, @NotNull Project project, @Nullable ProcessListener processListener, @Nullable FlutterCreateAdditionalSettings additionalSettings) {
        if (baseDir == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(12);
        }
        if (project == null) {
            FlutterModuleBuilder.$$$reportNull$$$0(13);
        }
        ProgressManager progress = ProgressManager.getInstance();
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        FlutterUtils.disableGradleProjectMigrationNotification(project);
        progress.runProcessWithProgressSynchronously(() -> {
            if (sdk == null) {
                FlutterModuleBuilder.$$$reportNull$$$0(14);
            }
            if (baseDir == null) {
                FlutterModuleBuilder.$$$reportNull$$$0(15);
            }
            progress.getProgressIndicator().setIndeterminate(true);
            result.set(sdk.createFiles(baseDir, null, processListener, additionalSettings));
        }, "Creating Flutter Project", false, project);
        return result.get();
    }

    public void setFlutterSdkPath(String s) {
        ComboBoxEditor combo = this.myStep.myPeer.getSdkEditor();
        combo.setItem(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDirPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flutterModuleName";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/module/FlutterModuleBuilder";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/module/FlutterModuleBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilderId";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAndroidModule";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidModuleFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validateModuleName";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modifySettingsStep";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "modifyProjectTypeStep";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "runFlutterCreateWithProgress";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runFlutterCreateWithProgress$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FlutterModuleWizardStep
    extends ModuleWizardStep
    implements Disposable {
        private final FlutterGeneratorPeer myPeer;

        public FlutterModuleWizardStep(@NotNull WizardContext context) {
            if (context == null) {
                FlutterModuleWizardStep.$$$reportNull$$$0(0);
            }
            this.myPeer = new FlutterGeneratorPeer(context);
        }

        public JComponent getComponent() {
            return this.myPeer.getComponent();
        }

        public void updateDataModel() {
        }

        public boolean validate() {
            boolean valid = this.myPeer.validate();
            if (valid) {
                this.myPeer.apply();
            }
            return valid;
        }

        public void dispose() {
        }

        @Nullable
        private FlutterSdk getFlutterSdk() {
            String sdkPath = this.myPeer.getSdkComboPath();
            if (!sdkPath.isEmpty()) {
                try {
                    LocalFileSystem.getInstance().refreshAndFindFileByPath(sdkPath);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return FlutterSdk.forPath(sdkPath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "io/flutter/module/FlutterModuleBuilder$FlutterModuleWizardStep", "<init>"));
        }
    }
}

