/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.SearchTextField;
import java.awt.event.KeyEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class LogFilterTextField
extends SearchTextField {
    @Nullable
    private OnFilterListener onFilterListener;

    public LogFilterTextField() {
        super(true);
        this.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                LogFilterTextField.this.doFilterIfNeeded();
            }
        });
    }

    public void setOnFilterListener(@Nullable OnFilterListener onFilterListener) {
        this.onFilterListener = onFilterListener;
    }

    protected boolean preprocessEventForTextField(KeyEvent e) {
        if (10 == e.getKeyCode() || '\n' == e.getKeyChar()) {
            e.consume();
            this.addCurrentTextToHistory();
        }
        return super.preprocessEventForTextField(e);
    }

    protected void onFocusLost() {
        super.addCurrentTextToHistory();
        this.doFilterIfNeeded();
    }

    protected void onFieldCleared() {
        this.doFilterIfNeeded();
    }

    private void doFilterIfNeeded() {
        if (this.onFilterListener != null) {
            this.onFilterListener.onFilter();
        }
    }

    public static interface OnFilterListener {
        public void onFilter();
    }
}

