/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.RightAlignedToolbarAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogConstants;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogFilterPanel;
import io.flutter.logging.FlutterLogTree;
import io.flutter.run.daemon.FlutterApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogView
extends JPanel
implements ConsoleView,
DataProvider,
FlutterLog.Listener {
    @NotNull
    private static final Logger LOG = Logger.getInstance(FlutterLogView.class);
    @NotNull
    private static final Map<FlutterLog.Level, TextAttributesKey> LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP;
    @NotNull
    private static final SimpleTextAttributes REGULAR_ATTRIBUTES;
    @NotNull
    private final Map<FlutterLog.Level, SimpleTextAttributes> textAttributesByLogLevelCache;
    @NotNull
    final FlutterApp app;
    private final EntryModel entryModel;
    private final SimpleToolWindowPanel toolWindowPanel;
    @NotNull
    private final FlutterLogTree.TreeModel logModel;
    private final FlutterLogTree logTree;
    @NotNull
    private final FlutterLogFilterPanel filterPanel;
    private SimpleTreeBuilder builder;

    public FlutterLogView(final @NotNull FlutterApp app) {
        if (app == null) {
            FlutterLogView.$$$reportNull$$$0(0);
        }
        this.textAttributesByLogLevelCache = new ConcurrentHashMap<FlutterLog.Level, SimpleTextAttributes>();
        this.entryModel = new EntryModel();
        this.filterPanel = new FlutterLogFilterPanel(param -> this.doFilter());
        this.app = app;
        this.computeTextAttributesByLogLevelCache();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(EditorColorsManager.TOPIC, scheme -> this.computeTextAttributesByLogLevelCache());
        FlutterLog flutterLog = app.getFlutterLog();
        flutterLog.addListener(this, (Disposable)this);
        Content content = ContentFactory.SERVICE.getInstance().createContent(null, null, false);
        content.setCloseable(false);
        this.toolWindowPanel = new SimpleToolWindowPanel(true, true);
        content.setComponent((JComponent)this.toolWindowPanel);
        JPanel toolbar = this.createToolbar();
        this.toolWindowPanel.setToolbar((JComponent)toolbar);
        this.logTree = new FlutterLogTree(app, this.entryModel, (Disposable)this);
        this.logModel = this.logTree.getLogTreeModel();
        this.logTree.setTableHeader(null);
        this.logTree.setRootVisible(false);
        this.logTree.setExpandableItemsEnabled(true);
        this.logTree.getTree().setScrollsOnExpand(true);
        this.logTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", FlutterLogView.this.getTreePopupActions());
                popupMenu.getComponent().show(comp, x, y);
            }

            public void mouseClicked(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                int column = table.columnAtPoint(e.getPoint());
                if (row == -1 || column == -1) {
                    return;
                }
                TableCellRenderer cellRenderer = table.getCellRenderer(row, column);
                if (cellRenderer instanceof ColoredTableCellRenderer) {
                    ColoredTableCellRenderer renderer = (ColoredTableCellRenderer)cellRenderer;
                    Rectangle rc = table.getCellRect(row, column, false);
                    Object tag = renderer.getFragmentTagAt(e.getX() - rc.x);
                    if (tag instanceof OpenFileHyperlinkInfo) {
                        ((OpenFileHyperlinkInfo)tag).navigate(app.getProject());
                    }
                }
            }
        });
        this.logTree.getColumn("Time").setMinWidth(100);
        this.logTree.getColumn("Time").setMaxWidth(100);
        this.logTree.getColumn("Sequence").setMinWidth(50);
        this.logTree.getColumn("Sequence").setMaxWidth(50);
        this.logTree.getColumn("Level").setMinWidth(70);
        this.logTree.getColumn("Level").setMaxWidth(70);
        this.logTree.getColumn("Category").setMinWidth(110);
        this.logTree.getColumn("Category").setMaxWidth(110);
        this.logTree.getColumn("Message").setMinWidth(100);
        JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)((Object)this.logTree), (int)20, (int)30);
        this.logModel.setScrollPane(pane);
        this.toolWindowPanel.setContent((JComponent)pane);
    }

    private void computeTextAttributesByLogLevelCache() {
        EditorColorsScheme globalEditorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        this.textAttributesByLogLevelCache.clear();
        for (FlutterLog.Level level : FlutterLog.Level.values()) {
            try {
                TextAttributesKey key = LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.get((Object)level);
                Color color = globalEditorColorsScheme.getAttributes(key).getForegroundColor();
                SimpleTextAttributes textAttributes = new SimpleTextAttributes(0, color);
                this.textAttributesByLogLevelCache.put(level, textAttributes);
            }
            catch (Exception e) {
                LOG.warn("Error when get text attributes by log level", (Throwable)e);
            }
        }
    }

    private ActionGroup getTreePopupActions() {
        return new ActionGroup(){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[]{new CopyToClipboardAction(), new Separator(), new ClearLogAction()};
                if (anActionArray == null) {
                    2.$$$reportNull$$$0(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "io/flutter/logging/FlutterLogView$2", "getChildren"));
            }
        };
    }

    private void doFilter() {
        FlutterLogFilterPanel.FilterParam param = this.filterPanel.getCurrentFilterParam();
        String text = param.getExpression();
        FlutterLogTree.EntryFilter filter = new FlutterLogTree.EntryFilter(param);
        ApplicationManager.getApplication().invokeLater(() -> this.logTree.setFilter(filter));
    }

    @NotNull
    private FlutterLog getFlutterLog() {
        FlutterLog flutterLog = this.app.getFlutterLog();
        if (flutterLog == null) {
            FlutterLogView.$$$reportNull$$$0(1);
        }
        return flutterLog;
    }

    @NotNull
    private JPanel createToolbar() {
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new FilterStatusLabel());
        toolbarGroup.add((AnAction)new ConfigureAction());
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("FlutterLogViewToolbar", (ActionGroup)toolbarGroup, true);
        actionToolbar.setMiniMode(false);
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        toolbar.add((Component)this.filterPanel.getRoot(), "West");
        toolbar.add((Component)actionToolbar.getComponent(), "East");
        JPanel jPanel = toolbar;
        if (jPanel == null) {
            FlutterLogView.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Override
    public void onEvent(@NotNull FlutterLogEntry entry) {
        if (entry == null) {
            FlutterLogView.$$$reportNull$$$0(3);
        }
        this.logTree.reload();
    }

    public void print(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            FlutterLogView.$$$reportNull$$$0(4);
        }
        if (contentType == null) {
            FlutterLogView.$$$reportNull$$$0(5);
        }
        this.getFlutterLog().addConsoleEntry(text, contentType);
    }

    public void clear() {
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.getFlutterLog().listenToProcess(processHandler, (Disposable)this);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value) {
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            FlutterLogView.$$$reportNull$$$0(6);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            FlutterLogView.$$$reportNull$$$0(7);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            FlutterLogView.$$$reportNull$$$0(8);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            FlutterLogView.$$$reportNull$$$0(9);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        AnAction[] anActionArray = new AnAction[]{new ScrollToEndAction(), new ClearLogAction()};
        if (anActionArray == null) {
            FlutterLogView.$$$reportNull$$$0(10);
        }
        return anActionArray;
    }

    public void allowHeavyFilters() {
    }

    public void dispose() {
    }

    @Nullable
    public Object getData(String dataId) {
        return null;
    }

    public JComponent getComponent() {
        return this.toolWindowPanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.logTree;
    }

    static {
        REGULAR_ATTRIBUTES = SimpleTextAttributes.GRAY_ATTRIBUTES;
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP = new HashMap<FlutterLog.Level, TextAttributesKey>();
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.NONE, FlutterLogConstants.NONE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINEST, FlutterLogConstants.FINEST_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINER, FlutterLogConstants.FINER_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.FINE, FlutterLogConstants.FINE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.CONFIG, FlutterLogConstants.CONFIG_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.INFO, FlutterLogConstants.INFO_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.WARNING, FlutterLogConstants.WARNING_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.SEVERE, FlutterLogConstants.SEVERE_OUTPUT_KEY);
        LOG_LEVEL_TEXT_ATTRIBUTES_KEY_MAP.put(FlutterLog.Level.SHOUT, FlutterLogConstants.SHOUT_OUTPUT_KEY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlutterLog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FilterStatusLabel
    extends AnAction
    implements CustomComponentAction,
    RightAlignedToolbarAction,
    FlutterLogTree.EventCountListener {
        JBLabel label;
        JPanel panel;

        private FilterStatusLabel() {
        }

        public void actionPerformed(AnActionEvent e) {
        }

        public JComponent createCustomComponent(Presentation presentation) {
            this.panel = new JPanel();
            this.label = new JBLabel();
            this.label.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.label.setForeground(UIUtil.getInactiveTextColor());
            this.label.setBorder((Border)JBUI.Borders.emptyRight((int)10));
            this.panel.add((Component)this.label);
            FlutterLogView.this.logTree.addListener(this, (Disposable)FlutterLogView.this);
            return this.panel;
        }

        @Override
        public void updated(int filtered, int total) {
            if (this.label != null && this.label.isVisible()) {
                StringBuilder sb = new StringBuilder();
                sb.append(total).append(" event");
                if (total != 1) {
                    sb.append("s");
                }
                if (filtered > 0) {
                    sb.append(" (").append(filtered).append(" filtered)");
                }
                this.label.setText(sb.toString());
                SwingUtilities.invokeLater(this.panel::repaint);
            }
        }

        String countString(int count) {
            if (count > 1000) {
                return "1000+";
            }
            return Integer.toString(count);
        }
    }

    private class CopyToClipboardAction
    extends AnAction {
        CopyToClipboardAction() {
            super("Copy as Text", "Copy selected entries to the clipboard", AllIcons.Actions.Copy);
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().invokeLater(() -> {
                int[] rows = FlutterLogView.this.logTree.getSelectedRows();
                FlutterLogTree.LogRootTreeNode root = FlutterLogView.this.logModel.getRoot();
                TreePath[] paths = FlutterLogView.this.logTree.getTree().getSelectionPaths();
                if (paths != null) {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringBuilder sb = new StringBuilder();
                    for (TreePath path : paths) {
                        Object pathComponent = path.getLastPathComponent();
                        if (!(pathComponent instanceof FlutterLogTree.FlutterEventNode)) continue;
                        ((FlutterLogTree.FlutterEventNode)pathComponent).describeTo(sb);
                    }
                    StringSelection selection = new StringSelection(sb.toString());
                    clipboard.setContents(selection, selection);
                }
            });
        }
    }

    private class ScrollToEndAction
    extends ToggleAction {
        ScrollToEndAction() {
            super("Scroll to the end", "Scroll to the end", AllIcons.RunConfigurations.Scroll_down);
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FlutterLogView)FlutterLogView.this).logModel.autoScrollToEnd;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ApplicationManager.getApplication().invokeLater(() -> {
                ((FlutterLogView)FlutterLogView.this).logModel.autoScrollToEnd = state;
                FlutterLogView.this.logModel.scrollToEnd();
            });
        }
    }

    private class ClearLogAction
    extends AnAction {
        ClearLogAction() {
            super("Clear All", "Clear the log", AllIcons.Actions.GC);
        }

        public void actionPerformed(AnActionEvent e) {
            ApplicationManager.getApplication().invokeLater(() -> FlutterLogView.this.logTree.clearEntries());
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(FlutterLogView.this.logModel.getRoot().getChildCount() > 0);
        }
    }

    private class ShowColorsAction
    extends ToggleAction {
        ShowColorsAction() {
            super("Color entries");
        }

        public boolean isSelected(AnActionEvent e) {
            return ((FlutterLogView)FlutterLogView.this).entryModel.showColors;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            ((FlutterLogView)FlutterLogView.this).entryModel.showColors = state;
            FlutterLogView.this.logModel.update();
        }
    }

    private class ShowLevelAction
    extends ToggleAction {
        ShowLevelAction() {
            super("Show log levels");
        }

        public boolean isSelected(AnActionEvent e) {
            return FlutterLogView.this.logModel.shouldShowLogLevels();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FlutterLogView.this.logModel.setShowLogLevels(state);
            FlutterLogView.this.logModel.update();
        }
    }

    private class ShowCategoryAction
    extends ToggleAction {
        ShowCategoryAction() {
            super("Show categories");
        }

        public boolean isSelected(AnActionEvent e) {
            return FlutterLogView.this.logModel.shouldShowCategories();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FlutterLogView.this.logModel.setShowCategories(state);
            FlutterLogView.this.logModel.update();
        }
    }

    private class ShowSequenceNumbersAction
    extends ToggleAction {
        ShowSequenceNumbersAction() {
            super("Show sequence numbers");
        }

        public boolean isSelected(AnActionEvent e) {
            return FlutterLogView.this.logModel.shouldShowSequenceNumbers();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FlutterLogView.this.logModel.setShowSequenceNumbers(state);
            FlutterLogView.this.logModel.update();
        }
    }

    private class ShowTimeStampsAction
    extends ToggleAction {
        ShowTimeStampsAction() {
            super("Show timestamps");
        }

        public boolean isSelected(AnActionEvent e) {
            return FlutterLogView.this.logModel.shouldShowTimestamps();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FlutterLogView.this.logModel.setShowTimestamps(state);
            FlutterLogView.this.logModel.update();
        }
    }

    class ConfigureAction
    extends AnAction
    implements RightAlignedToolbarAction {
        private final DefaultActionGroup actionGroup;

        public ConfigureAction() {
            super("Configure", null, AllIcons.General.Gear);
            this.actionGroup = this.createPopupActionGroup();
        }

        ActionButton getActionButton() {
            Presentation presentation = this.getTemplatePresentation().clone();
            ActionButton actionButton = new ActionButton((AnAction)this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            presentation.putClientProperty("button", (Object)actionButton);
            return actionButton;
        }

        public final void update(AnActionEvent e) {
            e.getPresentation().setEnabled(FlutterLogView.this.app.isSessionActive());
        }

        public void actionPerformed(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            JComponent component = (JComponent)presentation.getClientProperty("button");
            if (component == null && e.getInputEvent().getSource() instanceof JComponent) {
                component = (JComponent)e.getInputEvent().getSource();
            }
            if (component == null) {
                return;
            }
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)this.actionGroup);
            popupMenu.getComponent().show(component, component.getWidth(), 0);
        }

        private DefaultActionGroup createPopupActionGroup() {
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new ShowTimeStampsAction());
            group.add((AnAction)new ShowSequenceNumbersAction());
            group.add((AnAction)new ShowLevelAction());
            group.add((AnAction)new ShowCategoryAction());
            group.add((AnAction)new Separator());
            group.add((AnAction)new ShowColorsAction());
            return group;
        }
    }

    private class EntryModel
    implements FlutterLogTree.EntryModel {
        boolean showColors;

        private EntryModel() {
        }

        @Override
        public SimpleTextAttributes style(@Nullable FlutterLogEntry entry, int attributes) {
            FlutterLog.Level level;
            if (this.showColors && entry != null && (level = FlutterLog.Level.forValue(entry.getLevel())) != null) {
                return this.getTextAttributesByLogLevel(level);
            }
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }

        @NotNull
        private SimpleTextAttributes getTextAttributesByLogLevel(@NotNull FlutterLog.Level level) {
            if (level == null) {
                EntryModel.$$$reportNull$$$0(0);
            }
            if (FlutterLogView.this.textAttributesByLogLevelCache.containsKey((Object)level)) {
                SimpleTextAttributes simpleTextAttributes = (SimpleTextAttributes)FlutterLogView.this.textAttributesByLogLevelCache.get((Object)level);
                if (simpleTextAttributes == null) {
                    EntryModel.$$$reportNull$$$0(1);
                }
                return simpleTextAttributes;
            }
            SimpleTextAttributes simpleTextAttributes = REGULAR_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                EntryModel.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogView$EntryModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogView$EntryModel";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesByLogLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getTextAttributesByLogLevel";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

