/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.ColumnInfo;
import io.flutter.console.FlutterConsoleFilter;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogFilterPanel;
import io.flutter.run.daemon.FlutterApp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogTree
extends TreeTable {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private final EventDispatcher<EventCountListener> countDispatcher;
    private final TreeModel model;
    private EntryFilter filter;

    public FlutterLogTree(@NotNull FlutterApp app, @NotNull EntryModel entryModel, @NotNull Disposable parent) {
        if (app == null) {
            FlutterLogTree.$$$reportNull$$$0(0);
        }
        if (entryModel == null) {
            FlutterLogTree.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            FlutterLogTree.$$$reportNull$$$0(2);
        }
        this(new TreeModel(app, entryModel, parent));
    }

    FlutterLogTree(@NotNull TreeModel model) {
        if (model == null) {
            FlutterLogTree.$$$reportNull$$$0(3);
        }
        super((TreeTableModel)model);
        this.countDispatcher = EventDispatcher.create(EventCountListener.class);
        model.setTree((JTree)this.getTree());
        this.model = model;
    }

    public void addListener(@NotNull EventCountListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            FlutterLogTree.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            FlutterLogTree.$$$reportNull$$$0(5);
        }
        this.countDispatcher.addListener((EventListener)listener, parent);
    }

    public void removeListener(@NotNull EventCountListener listener) {
        if (listener == null) {
            FlutterLogTree.$$$reportNull$$$0(6);
        }
        this.countDispatcher.removeListener((EventListener)listener);
    }

    @NotNull
    TreeModel getLogTreeModel() {
        TreeModel treeModel = this.model;
        if (treeModel == null) {
            FlutterLogTree.$$$reportNull$$$0(7);
        }
        return treeModel;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.model.columns.getRenderer(column);
    }

    public void setFilter(@Nullable EntryFilter filter) {
        if (!Objects.equals(this.filter, filter)) {
            this.filter = filter;
            this.reload();
        }
    }

    void reload() {
        ApplicationManager.getApplication().invokeLater(() -> {
            this.model.getRoot().removeAllChildren();
            List<FlutterLogEntry> entries = this.model.log.getEntries();
            List<FlutterLogEntry> matched = entries.stream().filter(entry -> this.filter == null || this.filter.accept((FlutterLogEntry)entry)).collect(Collectors.toList());
            this.model.appendNodes(matched);
            ((EventCountListener)this.countDispatcher.getMulticaster()).updated(entries.size() - matched.size(), entries.size());
        });
    }

    public void clearEntries() {
        this.model.clearEntries();
        this.reload();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryModel";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogTree";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface EventCountListener
    extends EventListener {
        public void updated(int var1, int var2);
    }

    public static interface EntryModel {
        public SimpleTextAttributes style(@Nullable FlutterLogEntry var1, int var2);
    }

    public static class EntryFilter {
        @NotNull
        private final FlutterLogFilterPanel.FilterParam filterParam;

        public EntryFilter(@NotNull FlutterLogFilterPanel.FilterParam filterParam) {
            if (filterParam == null) {
                EntryFilter.$$$reportNull$$$0(0);
            }
            this.filterParam = filterParam;
        }

        public boolean accept(@NotNull FlutterLogEntry entry) {
            String standardCategory;
            if (entry == null) {
                EntryFilter.$$$reportNull$$$0(1);
            }
            if (entry.getLevel() < this.filterParam.getLogLevel().value) {
                return false;
            }
            String text = this.filterParam.getExpression();
            if (text == null) {
                return true;
            }
            boolean isMatchCase = this.filterParam.isMatchCase();
            String standardText = isMatchCase ? text : text.toLowerCase();
            String standardMessage = isMatchCase ? entry.getMessage() : entry.getMessage().toLowerCase();
            String string = standardCategory = isMatchCase ? entry.getCategory() : entry.getCategory().toLowerCase();
            if (this.acceptByCheckingRegexOption(standardCategory, standardText)) {
                return true;
            }
            return this.acceptByCheckingRegexOption(standardMessage, standardText);
        }

        private boolean acceptByCheckingRegexOption(@NotNull String message, @NotNull String text) {
            if (message == null) {
                EntryFilter.$$$reportNull$$$0(2);
            }
            if (text == null) {
                EntryFilter.$$$reportNull$$$0(3);
            }
            if (this.filterParam.isRegex()) {
                return message.matches("(?s).*" + text + ".*");
            }
            return message.contains(text);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntryFilter filter = (EntryFilter)o;
            return Objects.equals(this.filterParam, filter.filterParam);
        }

        public int hashCode() {
            return Objects.hash(this.filterParam);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filterParam";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "io/flutter/logging/FlutterLogTree$EntryFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptByCheckingRegexOption";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class FlutterEventNode
    extends DefaultMutableTreeNode {
        final FlutterLogEntry entry;

        FlutterEventNode(FlutterLogEntry entry) {
            this.entry = entry;
        }

        public void describeTo(@NotNull StringBuilder buffer) {
            if (buffer == null) {
                FlutterEventNode.$$$reportNull$$$0(0);
            }
            buffer.append(TIMESTAMP_FORMAT.format(this.entry.getTimestamp())).append(" ").append(this.entry.getSequenceNumber()).append(" ").append(this.entry.getLevel()).append(" ").append(this.entry.getCategory()).append(" ").append(this.entry.getMessage());
            if (!this.entry.getMessage().endsWith("\n")) {
                buffer.append("\n");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "io/flutter/logging/FlutterLogTree$FlutterEventNode", "describeTo"));
        }
    }

    static class LogRootTreeNode
    extends DefaultMutableTreeNode {
        LogRootTreeNode() {
        }
    }

    static class TreeModel
    extends ListTreeTableModelOnColumns {
        @NotNull
        private final ColumnModel columns;
        @NotNull
        private final FlutterLog log;
        @NotNull
        private final Alarm uiThreadAlarm;
        boolean autoScrollToEnd;
        private List<TableColumn> tableColumns;
        private JScrollPane scrollPane;
        private TreeTable treeTable;
        private boolean color;

        public TreeModel(@NotNull FlutterApp app, @NotNull EntryModel entryModel, @NotNull Disposable parent) {
            if (app == null) {
                TreeModel.$$$reportNull$$$0(0);
            }
            if (entryModel == null) {
                TreeModel.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                TreeModel.$$$reportNull$$$0(2);
            }
            this(new ColumnModel(app, entryModel), parent);
        }

        private TreeModel(@NotNull ColumnModel columns, @NotNull Disposable parent) {
            if (columns == null) {
                TreeModel.$$$reportNull$$$0(3);
            }
            if (parent == null) {
                TreeModel.$$$reportNull$$$0(4);
            }
            super((TreeNode)new LogRootTreeNode(), columns.getInfos());
            this.log = columns.app.getFlutterLog();
            this.columns = columns;
            this.autoScrollToEnd = true;
            this.setShowSequenceNumbers(false);
            this.uiThreadAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
        }

        void scrollToEnd() {
            if (this.scrollPane != null) {
                JScrollBar vertical = this.scrollPane.getVerticalScrollBar();
                vertical.setValue(vertical.getMaximum());
            }
        }

        void update() {
            this.columns.update();
            this.reload(this.getRoot());
            this.treeTable.updateUI();
            if (this.autoScrollToEnd) {
                this.scrollToEnd();
            }
        }

        public LogRootTreeNode getRoot() {
            return (LogRootTreeNode)super.getRoot();
        }

        public void setScrollPane(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
        }

        public void setTree(JTree tree) {
            super.setTree(tree);
            this.treeTable = ((TreeTableTree)tree).getTreeTable();
            this.columns.init(this.treeTable);
        }

        public void clearEntries() {
            this.log.clear();
            this.getRoot().removeAllChildren();
            this.update();
        }

        public void appendNodes(List<FlutterLogEntry> entries) {
            if (this.treeTable == null || this.uiThreadAlarm.isDisposed()) {
                return;
            }
            this.uiThreadAlarm.cancelAllRequests();
            this.uiThreadAlarm.addRequest(() -> {
                LogRootTreeNode root = this.getRoot();
                entries.forEach(entry -> this.insertNodeInto(new FlutterEventNode((FlutterLogEntry)entry), root, root.getChildCount()));
                this.update();
                this.uiThreadAlarm.addRequest(() -> {
                    if (this.autoScrollToEnd) {
                        this.scrollToEnd();
                    }
                }, 100);
            }, 10);
        }

        public boolean shouldShowTimestamps() {
            return this.columns.isShowing("Time");
        }

        public void setShowTimestamps(boolean show) {
            this.columns.show("Time", show);
        }

        public boolean shouldShowSequenceNumbers() {
            return this.columns.isShowing("Sequence");
        }

        public void setShowSequenceNumbers(boolean show) {
            this.columns.show("Sequence", show);
        }

        public boolean shouldShowLogLevels() {
            return this.columns.isShowing("Level");
        }

        public void setShowLogLevels(boolean show) {
            this.columns.show("Level", show);
        }

        public void setShowCategories(boolean show) {
            this.columns.show("Category", show);
        }

        public boolean shouldShowCategories() {
            return this.columns.isShowing("Category");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "app";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryModel";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
            }
            objectArray[1] = "io/flutter/logging/FlutterLogTree$TreeModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ColumnModel {
        private final List<Column> columns;
        private final FlutterApp app;
        @NotNull
        private final EntryModel entryModel;
        boolean updateVisibility;
        private List<Column> visible;
        private ArrayList<TableColumn> tableColumns;
        private TreeTable treeTable;

        ColumnModel(@NotNull FlutterApp app, @NotNull EntryModel entryModel) {
            if (app == null) {
                ColumnModel.$$$reportNull$$$0(0);
            }
            if (entryModel == null) {
                ColumnModel.$$$reportNull$$$0(1);
            }
            this.columns = new ArrayList<Column>();
            this.app = app;
            this.entryModel = entryModel;
            this.columns.addAll(Arrays.asList(new Column("Time", (TableCellRenderer)((Object)new TimeCellRenderer())), new Column("Sequence", (TableCellRenderer)((Object)new SequenceCellRenderer())), new Column("Level", (TableCellRenderer)((Object)new LevelCellRenderer())), new Column("Category", (TableCellRenderer)((Object)new CategoryCellRenderer())), new Column("Message", (TableCellRenderer)((Object)new MessageCellRenderer(app.getModule())))));
            this.visible = this.columns.stream().filter(c -> c.show).collect(Collectors.toList());
        }

        void show(String column, boolean show) {
            this.columns.forEach(c -> {
                if (Objects.equals(column, c.getName())) {
                    c.show = show;
                }
            });
            this.updateVisibility = true;
            this.visible = this.columns.stream().filter(c -> c.show).collect(Collectors.toList());
        }

        void update() {
            if (this.updateVisibility) {
                Collections.list(this.treeTable.getColumnModel().getColumns()).forEach(c -> this.treeTable.removeColumn(c));
                if (this.isShowing("Time")) {
                    this.treeTable.addColumn(this.tableColumns.get(0));
                }
                if (this.isShowing("Sequence")) {
                    this.treeTable.addColumn(this.tableColumns.get(1));
                }
                if (this.isShowing("Level")) {
                    this.treeTable.addColumn(this.tableColumns.get(2));
                }
                if (this.isShowing("Category")) {
                    this.treeTable.addColumn(this.tableColumns.get(3));
                }
                this.tableColumns.subList(4, this.tableColumns.size()).forEach(c -> this.treeTable.addColumn(c));
            }
            this.updateVisibility = false;
        }

        ColumnInfo[] getInfos() {
            return this.columns.toArray(new ColumnInfo[0]);
        }

        public TableCellRenderer getRenderer(int column) {
            return this.visible.get(column).renderer;
        }

        public boolean isShowing(String column) {
            for (Column c : this.columns) {
                if (!Objects.equals(column, c.getName())) continue;
                return c.show;
            }
            return false;
        }

        public void init(TreeTable table) {
            this.treeTable = table;
            this.tableColumns = Collections.list(table.getColumnModel().getColumns());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "app";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryModel";
                    break;
                }
            }
            objectArray[1] = "io/flutter/logging/FlutterLogTree$ColumnModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MessageCellRenderer
        extends EntryCellRenderer {
            @Nullable
            private final FlutterConsoleFilter consoleFilter;

            MessageCellRenderer(Module module) {
                this.consoleFilter = module != null ? new FlutterConsoleFilter(module) : null;
            }

            @Override
            void render(FlutterLogEntry entry) {
                Filter.Result result;
                String message = entry.getMessage();
                int cursor = 0;
                Filter.Result result2 = result = this.consoleFilter != null ? this.consoleFilter.applyFilter(message, message.length()) : null;
                if (result != null) {
                    for (Filter.ResultItem item : result.getResultItems()) {
                        HyperlinkInfo hyperlinkInfo = item.getHyperlinkInfo();
                        if (hyperlinkInfo == null) continue;
                        int start = item.getHighlightStartOffset();
                        int end = item.getHighlightEndOffset();
                        if (cursor < start) {
                            this.appendStyled(entry, message.substring(cursor, start));
                        }
                        this.append(message.substring(start, end), SimpleTextAttributes.LINK_ATTRIBUTES, hyperlinkInfo);
                        cursor = end;
                    }
                }
                if (cursor < message.length()) {
                    this.appendStyled(entry, message.substring(cursor));
                }
            }
        }

        private class CategoryCellRenderer
        extends EntryCellRenderer {
            private CategoryCellRenderer() {
            }

            @Override
            void render(FlutterLogEntry entry) {
                this.appendStyled(entry, entry.getCategory());
            }
        }

        private class LevelCellRenderer
        extends EntryCellRenderer {
            private LevelCellRenderer() {
            }

            @Override
            void render(FlutterLogEntry entry) {
                FlutterLog.Level level = FlutterLog.Level.forValue(entry.getLevel());
                String value = level != null ? level.name() : Integer.toString(entry.getLevel());
                this.appendStyled(entry, value);
            }
        }

        private class SequenceCellRenderer
        extends EntryCellRenderer {
            private SequenceCellRenderer() {
            }

            @Override
            void render(FlutterLogEntry entry) {
                this.appendStyled(entry, Integer.toString(entry.getSequenceNumber()));
            }
        }

        private class TimeCellRenderer
        extends EntryCellRenderer {
            private TimeCellRenderer() {
            }

            @Override
            void render(FlutterLogEntry entry) {
                this.appendStyled(entry, TIMESTAMP_FORMAT.format(entry.getTimestamp()));
            }
        }

        class Column
        extends ColumnInfo<DefaultMutableTreeNode, FlutterLogEntry> {
            boolean show;
            @NotNull
            private final TableCellRenderer renderer;

            Column(@NotNull String name, TableCellRenderer renderer) {
                if (name == null) {
                    Column.$$$reportNull$$$0(0);
                }
                if (renderer == null) {
                    Column.$$$reportNull$$$0(1);
                }
                super(name);
                this.show = true;
                this.renderer = renderer;
            }

            boolean isShowing() {
                return this.show;
            }

            @Nullable
            public FlutterLogEntry valueOf(DefaultMutableTreeNode node) {
                if (node instanceof FlutterEventNode) {
                    return ((FlutterEventNode)node).entry;
                }
                return null;
            }

            public TableCellRenderer getCustomizedRenderer(DefaultMutableTreeNode o, TableCellRenderer renderer) {
                return this.renderer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "renderer";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/logging/FlutterLogTree$ColumnModel$Column";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private abstract class EntryCellRenderer
        extends ColoredTableCellRenderer {
            private EntryCellRenderer() {
            }

            protected final void customizeCellRenderer(JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (value instanceof FlutterLogEntry) {
                    this.render((FlutterLogEntry)value);
                }
            }

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            void appendStyled(FlutterLogEntry entry, String text) {
                this.append(text, ColumnModel.this.entryModel.style(entry, 0));
            }

            abstract void render(FlutterLogEntry var1);
        }
    }
}

