/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SearchTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.LogFilterTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogFilterPanel {
    @NotNull
    private final OnFilterListener onFilterListener;
    private JPanel root;
    private JCheckBox matchCaseCheckBox;
    private JCheckBox regexCheckBox;
    private SearchTextField textExpression;
    private JComboBox<FlutterLog.Level> logLevelComboBox;

    public FlutterLogFilterPanel(@NotNull OnFilterListener onFilterListener) {
        if (onFilterListener == null) {
            FlutterLogFilterPanel.$$$reportNull$$$0(0);
        }
        this.onFilterListener = onFilterListener;
        this.$$$setupUI$$$();
        this.matchCaseCheckBox.addItemListener(e -> {
            if (onFilterListener == null) {
                FlutterLogFilterPanel.$$$reportNull$$$0(6);
            }
            onFilterListener.onFilter(this.getCurrentFilterParam());
        });
        this.regexCheckBox.addItemListener(e -> {
            if (onFilterListener == null) {
                FlutterLogFilterPanel.$$$reportNull$$$0(5);
            }
            onFilterListener.onFilter(this.getCurrentFilterParam());
        });
        List logLevels = Arrays.stream(FlutterLog.Level.values()).collect(Collectors.toList());
        this.logLevelComboBox.setModel((ComboBoxModel<FlutterLog.Level>)new CollectionComboBoxModel(logLevels));
        this.logLevelComboBox.addActionListener(event -> {
            if (onFilterListener == null) {
                FlutterLogFilterPanel.$$$reportNull$$$0(4);
            }
            onFilterListener.onFilter(this.getCurrentFilterParam());
        });
        this.logLevelComboBox.setRenderer((ListCellRenderer<FlutterLog.Level>)new ColoredListCellRenderer<FlutterLog.Level>(){

            protected void customizeCellRenderer(@NotNull JList<? extends FlutterLog.Level> list, FlutterLog.Level value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                String label = index == -1 && value == FlutterLog.Level.NONE ? "" : value.name().toLowerCase();
                this.append(label);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "io/flutter/logging/FlutterLogFilterPanel$1", "customizeCellRenderer"));
            }
        });
    }

    @NotNull
    public FilterParam getCurrentFilterParam() {
        Object selected = this.logLevelComboBox.getSelectedItem();
        FlutterLog.Level logLevel = selected == null ? FlutterLog.Level.NONE : (FlutterLog.Level)((Object)selected);
        FilterParam filterParam = new FilterParam(this.textExpression.getText(), this.matchCaseCheckBox.isSelected(), this.regexCheckBox.isSelected(), logLevel);
        if (filterParam == null) {
            FlutterLogFilterPanel.$$$reportNull$$$0(1);
        }
        return filterParam;
    }

    @NotNull
    public JPanel getRoot() {
        JPanel jPanel = this.root;
        if (jPanel == null) {
            FlutterLogFilterPanel.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public String getExpression() {
        return this.textExpression.getText();
    }

    public void setTextFieldFg(boolean inactive) {
        this.textExpression.getTextEditor().setForeground(inactive ? UIUtil.getInactiveTextColor() : UIUtil.getActiveTextColor());
    }

    public boolean isRegex() {
        return this.regexCheckBox.isSelected();
    }

    public boolean isMatchCase() {
        return this.regexCheckBox.isSelected();
    }

    private void createUIComponents() {
        this.textExpression = this.createSearchTextField();
    }

    @NotNull
    private SearchTextField createSearchTextField() {
        LogFilterTextField logFilterTextField = new LogFilterTextField();
        logFilterTextField.setOnFilterListener(() -> this.onFilterListener.onFilter(this.getCurrentFilterParam()));
        LogFilterTextField logFilterTextField2 = logFilterTextField;
        if (logFilterTextField2 == null) {
            FlutterLogFilterPanel.$$$reportNull$$$0(3);
        }
        return logFilterTextField2;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.createUIComponents();
        this.root = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(true);
        jPanel.setMinimumSize(new Dimension(500, 35));
        jPanel.setPreferredSize(new Dimension(500, 35));
        this.matchCaseCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Match case");
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.regexCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Regex");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 3, 1, 1, 8, 0, 3, 0, null, null, null));
        SearchTextField searchTextField = this.textExpression;
        jPanel.add((Component)searchTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(50, -1), new Dimension(200, -1), null));
        JComboBox jComboBox = new JComboBox();
        this.logLevelComboBox = jComboBox;
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("NONE");
        defaultComboBoxModel.addElement("FINEST");
        defaultComboBoxModel.addElement("FINER");
        defaultComboBoxModel.addElement("FINE");
        defaultComboBoxModel.addElement("CONFIG");
        defaultComboBoxModel.addElement("INFO");
        defaultComboBoxModel.addElement("WARNING");
        defaultComboBoxModel.addElement("SEVERE");
        defaultComboBoxModel.addElement("SHOUT");
        jComboBox.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 0, 6, 0, new Dimension(100, -1), new Dimension(100, -1), new Dimension(100, -1)));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFilterListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogFilterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogFilterPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFilterParam";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface OnFilterListener {
        public void onFilter(@NotNull FilterParam var1);
    }

    static class FilterParam {
        @Nullable
        private final String expression;
        private final boolean isMatchCase;
        private final boolean isRegex;
        @NotNull
        private final FlutterLog.Level logLevel;

        public FilterParam(@Nullable String expression, boolean isMatchCase, boolean isRegex, @NotNull FlutterLog.Level logLevel) {
            if (logLevel == null) {
                FilterParam.$$$reportNull$$$0(0);
            }
            this.expression = expression;
            this.isMatchCase = isMatchCase;
            this.isRegex = isRegex;
            this.logLevel = logLevel;
        }

        @Nullable
        public String getExpression() {
            return this.expression;
        }

        public boolean isMatchCase() {
            return this.isMatchCase;
        }

        public boolean isRegex() {
            return this.isRegex;
        }

        @NotNull
        public FlutterLog.Level getLogLevel() {
            FlutterLog.Level level = this.logLevel;
            if (level == null) {
                FilterParam.$$$reportNull$$$0(1);
            }
            return level;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterParam param = (FilterParam)o;
            return this.isMatchCase == param.isMatchCase && this.isRegex == param.isRegex && Objects.equals(this.expression, param.expression) && this.logLevel == param.logLevel;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.expression, this.isMatchCase, this.isRegex, this.logLevel});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "logLevel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/logging/FlutterLogFilterPanel$FilterParam";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/logging/FlutterLogFilterPanel$FilterParam";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLogLevel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

