/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import io.flutter.logging.FlutterLog;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.perf.HeapMonitor;
import io.flutter.run.daemon.DaemonApi;
import io.flutter.utils.StdoutJsonParser;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.Instance;
import org.dartlang.vm.service.element.IsolateRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLogEntryParser {
    public static final String LOG_CATEGORY = "flutter.log";
    public static final String TOOLS_CATEGORY = "flutter.tools";
    public static final String STDIO_STDOUT_CATEGORY = "stdout";
    private static final NumberFormat nf = new DecimalFormat();
    private static final NumberFormat df1 = new DecimalFormat();
    public static int GC_EVENT_LEVEL = FlutterLog.Level.FINER.value;
    private final StdoutJsonParser stdoutParser = new StdoutJsonParser();

    private static FlutterLogEntry parseLoggingEvent(@NotNull Event event) {
        int setLevel;
        String str;
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(0);
        }
        JsonObject json = event.getJson();
        JsonObject logRecord = json.get("logRecord").getAsJsonObject();
        Instance message = new Instance(logRecord.getAsJsonObject().get("message").getAsJsonObject());
        String category = LOG_CATEGORY;
        JsonObject loggerName = logRecord.getAsJsonObject().get("loggerName").getAsJsonObject();
        if (loggerName != null && (str = new Instance(loggerName).getValueAsString()) != null && !str.isEmpty()) {
            category = str;
        }
        int level = FlutterLogEntry.UNDEFINED_LEVEL.value;
        JsonElement levelElement = logRecord.getAsJsonObject().get("level");
        if (levelElement instanceof JsonPrimitive && (setLevel = levelElement.getAsInt()) > 0) {
            level = setLevel;
        }
        return new FlutterLogEntry(FlutterLogEntryParser.timestamp(event), category, level, message.getValueAsString());
    }

    @NotNull
    private static FlutterLogEntry parseGCEvent(@NotNull Event event) {
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(1);
        }
        IsolateRef isolateRef = event.getIsolate();
        HeapMonitor.HeapSpace newHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("new"));
        HeapMonitor.HeapSpace oldHeapSpace = new HeapMonitor.HeapSpace(event.getJson().getAsJsonObject("old"));
        double time = newHeapSpace.getTime() + oldHeapSpace.getTime();
        int used = newHeapSpace.getUsed() + newHeapSpace.getExternal() + oldHeapSpace.getUsed() + oldHeapSpace.getExternal();
        int maxHeap = newHeapSpace.getCapacity() + oldHeapSpace.getCapacity();
        long timeMs = Math.round(time * 1000.0);
        double usedMB = (double)used / 1048576.0;
        double maxMB = (double)maxHeap / 1048576.0;
        FlutterLogEntry flutterLogEntry = new FlutterLogEntry(FlutterLogEntryParser.timestamp(event), "runtime.gc", GC_EVENT_LEVEL, "collection time " + nf.format(timeMs) + "ms \u2022 " + df1.format(usedMB) + "MB used of " + df1.format(maxMB) + "MB \u2022 " + isolateRef.getId());
        if (flutterLogEntry == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(2);
        }
        return flutterLogEntry;
    }

    private static long timestamp() {
        return System.currentTimeMillis();
    }

    private static long timestamp(Event event) {
        if (event.getJson().has("timestamp")) {
            return event.getJson().get("timestamp").getAsLong();
        }
        return FlutterLogEntryParser.timestamp();
    }

    @Nullable
    public FlutterLogEntry parse(@Nullable String id, @Nullable Event event) {
        if (id != null && event != null) {
            switch (id) {
                case "_Logging": {
                    return FlutterLogEntryParser.parseLoggingEvent(event);
                }
                case "GC": {
                    return FlutterLogEntryParser.parseGCEvent(event);
                }
            }
        }
        return null;
    }

    @Nullable
    FlutterLogEntry parseDaemonEvent(@NotNull ProcessEvent event, @Nullable Key outputType) {
        String text;
        if (event == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(3);
        }
        if ((text = event.getText()).isEmpty()) {
            return null;
        }
        return this.parseDaemonEvent(text);
    }

    @VisibleForTesting
    @Nullable
    public FlutterLogEntry parseDaemonEvent(@NotNull String eventText) {
        if (eventText == null) {
            FlutterLogEntryParser.$$$reportNull$$$0(4);
        }
        this.stdoutParser.appendOutput(eventText);
        for (String line : this.stdoutParser.getAvailableLines()) {
            if (DaemonApi.parseAndValidateDaemonEvent(line.trim()) != null) continue;
            return new FlutterLogEntry(FlutterLogEntryParser.timestamp(), TOOLS_CATEGORY, line);
        }
        return null;
    }

    public FlutterLogEntry parseConsoleEvent(String text, ConsoleViewContentType type) {
        if (type == ConsoleViewContentType.NORMAL_OUTPUT) {
            return this.parseDaemonEvent(text);
        }
        return null;
    }

    static {
        df1.setMinimumFractionDigits(1);
        df1.setMaximumFractionDigits(1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/logging/FlutterLogEntryParser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/logging/FlutterLogEntryParser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGCEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseLoggingEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseGCEvent";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseDaemonEvent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

