/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.logging;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.util.EventDispatcher;
import io.flutter.logging.FlutterLogEntry;
import io.flutter.logging.FlutterLogEntryParser;
import io.flutter.server.vmService.VmServiceConsumers;
import io.flutter.settings.FlutterSettings;
import io.flutter.utils.VmServiceListenerAdapter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.element.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLog {
    public static final String LOGGING_STREAM_ID = "_Logging";
    private final EventDispatcher<Listener> dispatcher = EventDispatcher.create(Listener.class);
    private final FlutterLogEntryParser logEntryParser = new FlutterLogEntryParser();
    private final List<FlutterLogEntry> entries = new ArrayList<FlutterLogEntry>();

    public static boolean isLoggingEnabled() {
        return FlutterSettings.getInstance().useFlutterLogView();
    }

    public void addConsoleEntry(@NotNull String text, @NotNull ConsoleViewContentType contentType) {
        if (text == null) {
            FlutterLog.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            FlutterLog.$$$reportNull$$$0(1);
        }
        this.onEntry(this.logEntryParser.parseConsoleEvent(text, contentType));
    }

    public void addListener(@NotNull Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            FlutterLog.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            FlutterLog.$$$reportNull$$$0(3);
        }
        this.dispatcher.addListener((EventListener)listener, parent);
    }

    public void clear() {
        this.entries.clear();
    }

    public List<FlutterLogEntry> getEntries() {
        return ImmutableList.copyOf(this.entries);
    }

    public void removeListener(@NotNull Listener listener) {
        if (listener == null) {
            FlutterLog.$$$reportNull$$$0(4);
        }
        this.dispatcher.removeListener((EventListener)listener);
    }

    private void onEntry(@Nullable FlutterLogEntry entry) {
        if (entry != null) {
            this.entries.add(entry);
            entry.setSequenceNumber(this.entries.size());
            ((Listener)this.dispatcher.getMulticaster()).onEvent(entry);
        }
    }

    public void listenToProcess(@NotNull ProcessHandler processHandler, @NotNull Disposable parent) {
        if (processHandler == null) {
            FlutterLog.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            FlutterLog.$$$reportNull$$$0(6);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                FlutterLog.this.onEntry(FlutterLog.this.logEntryParser.parseDaemonEvent(event, outputType));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "io/flutter/logging/FlutterLog$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, parent);
    }

    public void listenToVm(@NotNull VmService vmService) {
        if (vmService == null) {
            FlutterLog.$$$reportNull$$$0(7);
        }
        if (!FlutterLog.isLoggingEnabled()) {
            return;
        }
        vmService.addVmServiceListener(new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                FlutterLog.this.onVmServiceReceived(streamId, event);
            }

            @Override
            public void connectionClosed() {
                FlutterLog.this.onVmConnectionClosed();
            }
        });
        vmService.streamListen(LOGGING_STREAM_ID, VmServiceConsumers.EMPTY_SUCCESS_CONSUMER);
    }

    private void onVmServiceReceived(String id, Event event) {
        this.onEntry(this.logEntryParser.parse(id, event));
    }

    private void onVmConnectionClosed() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        objectArray2[1] = "io/flutter/logging/FlutterLog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addConsoleEntry";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "listenToProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "listenToVm";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Level {
        NONE(0),
        FINEST(300),
        FINER(400),
        FINE(500),
        CONFIG(700),
        INFO(800),
        WARNING(900),
        SEVERE(1000),
        SHOUT(1200);

        final int value;

        private Level(int value) {
            this.value = value;
        }

        public static Level forValue(int value) {
            Level[] levels = Level.values();
            for (int i = 0; i < levels.length; ++i) {
                if (value < levels[i].value || i < levels.length - 1 && value >= levels[i + 1].value) continue;
                return levels[i];
            }
            return null;
        }
    }

    public static interface Listener
    extends EventListener {
        public void onEvent(@NotNull FlutterLogEntry var1);
    }
}

