/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import io.flutter.FlutterInitializer;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import io.flutter.inspector.InspectorTreeActionBase;
import io.flutter.server.vmService.frame.DartVmServiceValue;
import io.flutter.utils.AsyncUtils;
import java.util.concurrent.CompletableFuture;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class JumpToSourceActionBase
extends InspectorTreeActionBase {
    @NotNull
    private final String id;

    JumpToSourceActionBase(@NotNull String id) {
        if (id == null) {
            JumpToSourceActionBase.$$$reportNull$$$0(0);
        }
        this.id = id;
    }

    @Override
    protected void perform(DefaultMutableTreeNode node, DiagnosticsNode diagnosticsNode, AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        FlutterInitializer.getAnalytics().sendEvent("inspector", this.id);
        XNavigatable navigatable = sourcePosition -> {
            if (sourcePosition != null) {
                AppUIUtil.invokeOnEdt(() -> sourcePosition.createNavigatable(project).navigate(true), (Condition)project.getDisposed());
            }
        };
        XSourcePosition sourcePosition2 = this.getSourcePosition(diagnosticsNode);
        if (sourcePosition2 != null) {
            navigatable.setSourcePosition(sourcePosition2);
            return;
        }
        InspectorService.ObjectGroup inspectorService = diagnosticsNode.getInspectorService();
        CompletableFuture<DartVmServiceValue> valueFuture = inspectorService.toDartVmServiceValueForSourceLocation(diagnosticsNode.getValueRef());
        AsyncUtils.whenCompleteUiThread(valueFuture, (value, throwable) -> {
            if (throwable != null) {
                return;
            }
            this.startComputingSourcePosition((XValue)value, navigatable);
        });
    }

    protected abstract XSourcePosition getSourcePosition(DiagnosticsNode var1);

    protected abstract void startComputingSourcePosition(XValue var1, XNavigatable var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "io/flutter/inspector/JumpToSourceActionBase", "<init>"));
    }
}

