/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.ui.treeStructure.Tree;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.view.InspectorPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class InspectorTreeActionBase
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        Object diagnostic;
        DefaultMutableTreeNode node = InspectorTreeActionBase.getSelectedNode(e.getDataContext());
        if (node != null && (diagnostic = node.getUserObject()) instanceof DiagnosticsNode) {
            this.perform(node, (DiagnosticsNode)diagnostic, e);
        }
    }

    protected abstract void perform(DefaultMutableTreeNode var1, DiagnosticsNode var2, AnActionEvent var3);

    public void update(AnActionEvent e) {
        DefaultMutableTreeNode node = InspectorTreeActionBase.getSelectedNode(e.getDataContext());
        e.getPresentation().setEnabled(node != null && this.isEnabled(node, e));
    }

    protected boolean isEnabled(DefaultMutableTreeNode node, AnActionEvent e) {
        return node.getUserObject() instanceof DiagnosticsNode && this.isSupported((DiagnosticsNode)node.getUserObject());
    }

    protected boolean isSupported(DiagnosticsNode diagnosticsNode) {
        return true;
    }

    public static DefaultMutableTreeNode getSelectedNode(DataContext dataContext) {
        Tree tree = InspectorPanel.getTree(dataContext);
        if (tree == null) {
            return null;
        }
        TreePath path = tree.getSelectionPath();
        if (path == null) {
            return null;
        }
        return (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    public static DiagnosticsNode getSelectedValue(DataContext dataContext) {
        DefaultMutableTreeNode node = InspectorTreeActionBase.getSelectedNode(dataContext);
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        return userObject instanceof DiagnosticsNode ? (DiagnosticsNode)userObject : null;
    }
}

