/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import io.flutter.inspector.FPSPanel;
import io.flutter.inspector.StackLayout;
import io.flutter.perf.FlutterFramesMonitor;
import io.flutter.run.daemon.FlutterApp;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FPSDisplay {
    static final DecimalFormat df = new DecimalFormat();

    public static JPanel createJPanelView(Disposable parentDisposable, FlutterApp app) {
        JPanel panel = new JPanel(new StackLayout());
        panel.setDoubleBuffered(true);
        panel.setBorder(IdeBorderFactory.createBorder((int)10));
        panel.setPreferredSize(new Dimension(-1, 100));
        panel.setMaximumSize(new Dimension(Short.MAX_VALUE, 100));
        assert (app.getPerfService() != null);
        FlutterFramesMonitor flutterFramesMonitor = app.getPerfService().getFlutterFramesMonitor();
        FPSPanel fpsPanel = new FPSPanel(flutterFramesMonitor);
        JPanel labelsPanel = new JPanel();
        labelsPanel.setOpaque(false);
        labelsPanel.setLayout(new BoxLayout(labelsPanel, 0));
        panel.add(fpsPanel);
        panel.add(labelsPanel);
        JBLabel fpsLabel = new JBLabel();
        fpsLabel.setAlignmentY(0.0f);
        fpsLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        fpsLabel.setForeground(UIUtil.getLabelDisabledForeground());
        fpsLabel.setOpaque(false);
        fpsLabel.setBorder(JBUI.Borders.empty((int)4));
        JBLabel elapsedLabel = new JBLabel("", 4);
        elapsedLabel.setAlignmentY(0.0f);
        elapsedLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        elapsedLabel.setForeground(UIUtil.getLabelDisabledForeground());
        elapsedLabel.setOpaque(false);
        elapsedLabel.setBorder(JBUI.Borders.empty((int)4));
        labelsPanel.add((Component)fpsLabel);
        labelsPanel.add(Box.createHorizontalGlue());
        labelsPanel.add((Component)elapsedLabel);
        FlutterFramesMonitor.Listener listener = event -> {
            fpsPanel.update();
            int ms = Math.round((float)event.elapsedMicros / 1000.0f);
            elapsedLabel.setText(ms + "ms");
            SwingUtilities.invokeLater(() -> elapsedLabel.repaint());
            fpsLabel.setText(df.format(flutterFramesMonitor.getFPS()) + " FPS");
            SwingUtilities.invokeLater(() -> fpsLabel.repaint());
        };
        flutterFramesMonitor.addListener(listener);
        Disposer.register((Disposable)parentDisposable, () -> flutterFramesMonitor.removeListener(listener));
        return panel;
    }

    static {
        df.setMaximumFractionDigits(1);
    }
}

