/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.inspector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.flutter.inspector.DiagnosticsNode;
import io.flutter.inspector.InspectorService;
import java.util.ArrayList;

public class DiagnosticsPathNode {
    private final InspectorService.ObjectGroup inspectorService;
    private final JsonObject json;

    public DiagnosticsPathNode(JsonObject json, InspectorService.ObjectGroup inspectorService) {
        this.inspectorService = inspectorService;
        this.json = json;
    }

    public DiagnosticsNode getNode() {
        return new DiagnosticsNode(this.json.getAsJsonObject("node"), this.inspectorService, false);
    }

    public ArrayList<DiagnosticsNode> getChildren() {
        ArrayList<DiagnosticsNode> children = new ArrayList<DiagnosticsNode>();
        JsonElement childrenElement = this.json.get("children");
        if (childrenElement.isJsonNull()) {
            return children;
        }
        JsonArray childrenJson = childrenElement.getAsJsonArray();
        for (int i = 0; i < childrenJson.size(); ++i) {
            children.add(new DiagnosticsNode(childrenJson.get(i).getAsJsonObject(), this.inspectorService, false));
        }
        return children;
    }

    public int getChildIndex() {
        JsonElement childIndex = this.json.get("childIndex");
        if (childIndex.isJsonNull()) {
            return -1;
        }
        return childIndex.getAsInt();
    }
}

