/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.ColorIcon;
import com.jetbrains.lang.dart.psi.DartArrayAccessExpression;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import io.flutter.editor.FlutterColors;
import io.flutter.editor.FlutterIconRenderer;
import io.flutter.editor.FlutterMaterialIcons;
import io.flutter.utils.FlutterModuleUtils;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FlutterEditorAnnotator
implements Annotator {
    private static final Logger LOG = Logger.getInstance(FlutterEditorAnnotator.class);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            FlutterEditorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            FlutterEditorAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        if (element instanceof DartReferenceExpression || element instanceof DartArrayAccessExpression) {
            String key;
            Icon icon;
            if (!FlutterModuleUtils.isInFlutterModule(element)) {
                return;
            }
            String text = element.getText();
            if (text.startsWith("Colors.")) {
                String key2 = text.substring("Colors.".length());
                FlutterColors.FlutterColor color = FlutterColors.getColor(key2);
                if (color != null) {
                    if (!color.isPrimary()) {
                        FlutterEditorAnnotator.attachColorIcon(element, holder, color.getAWTColor());
                    } else {
                        boolean inShadeExpression;
                        boolean inColorIndexExpression = element.getParent() instanceof DartArrayAccessExpression;
                        boolean bl = inShadeExpression = element.getParent() instanceof DartReferenceExpression && element.getParent().getText().startsWith(text + ".shade");
                        if (!inShadeExpression && !inColorIndexExpression) {
                            FlutterEditorAnnotator.attachColorIcon(element, holder, color.getAWTColor());
                        }
                    }
                }
            } else if (text.startsWith("Icons.") && (icon = FlutterMaterialIcons.getMaterialIconForName(key = text.substring("Icons.".length()))) != null) {
                FlutterEditorAnnotator.attachIcon(element, holder, icon);
            }
        } else if (element instanceof DartNewExpression) {
            String text = element.getText();
            if (text.startsWith("const IconData(") && text.endsWith(")")) {
                String val = text.substring("const IconData(".length());
                int index = (val = val.substring(0, val.length() - 1)).indexOf(44);
                if (index != -1) {
                    val = val.substring(0, index);
                }
                try {
                    int value = val.startsWith("0x") ? Integer.parseInt(val.substring(2), 16) : Integer.parseInt(val);
                    String hex = Integer.toHexString(value);
                    Icon icon = FlutterMaterialIcons.getMaterialIconForHex(hex);
                    if (icon != null) {
                        FlutterEditorAnnotator.attachIcon(element, holder, icon);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (text.startsWith("const Color(") && text.endsWith(")")) {
                String val = text.substring("const Color(".length());
                val = val.substring(0, val.length() - 1);
                try {
                    long value = val.startsWith("0x") ? Long.parseLong(val.substring(2), 16) : Long.parseLong(val);
                    Color color = new Color((int)(value >> 16) & 0xFF, (int)(value >> 8) & 0xFF, (int)value & 0xFF, (int)(value >> 24) & 0xFF);
                    FlutterEditorAnnotator.attachColorIcon(element, holder, color);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private static void attachColorIcon(PsiElement element, AnnotationHolder holder, Color color) {
        FlutterEditorAnnotator.attachIcon(element, holder, (Icon)new ColorIcon(16, 12, color, true));
    }

    private static void attachIcon(PsiElement element, AnnotationHolder holder, Icon icon) {
        try {
            Annotation annotation = holder.createInfoAnnotation(element, null);
            annotation.setGutterIconRenderer((GutterIconRenderer)new FlutterIconRenderer(icon, element));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "io/flutter/editor/FlutterEditorAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

