/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.jetbrains.lang.dart.ide.completion.DartCompletionExtension;
import com.jetbrains.lang.dart.ide.completion.DartServerCompletionContributor;
import io.flutter.editor.FlutterColors;
import io.flutter.editor.FlutterMaterialIcons;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterCompletionContributor
extends DartCompletionExtension {
    private static final int ICON_SIZE = 16;
    private static final Icon EMPTY_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16));

    @Nullable
    public LookupElementBuilder createLookupElement(@NotNull Project project, @NotNull CompletionSuggestion suggestion) {
        Icon icon;
        if (project == null) {
            FlutterCompletionContributor.$$$reportNull$$$0(0);
        }
        if (suggestion == null) {
            FlutterCompletionContributor.$$$reportNull$$$0(1);
        }
        if ((icon = FlutterCompletionContributor.findIcon(suggestion)) != null) {
            LookupElementBuilder lookup = DartServerCompletionContributor.createLookupElement((Project)project, (CompletionSuggestion)suggestion).withTypeText("", icon, false);
            Method rightAligned = ReflectionUtil.getMethod(lookup.getClass(), (String)"withTypeIconRightAligned", (Class[])new Class[0]);
            if (rightAligned != null) {
                try {
                    return (LookupElementBuilder)rightAligned.invoke((Object)lookup, true);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
            return lookup;
        }
        return null;
    }

    private static Icon findIcon(@NotNull CompletionSuggestion suggestion) {
        String name;
        String returnType;
        Element element;
        if (suggestion == null) {
            FlutterCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((element = suggestion.getElement()) != null && !StringUtils.isEmpty((String)(returnType = element.getReturnType())) && (name = element.getName()) != null) {
            String declaringType = suggestion.getDeclaringType();
            if (Objects.equals(declaringType, "Colors")) {
                FlutterColors.FlutterColor color = FlutterColors.getColor(name);
                if (color != null) {
                    return JBUI.scale((JBUI.JBIcon)new ColorIcon(16, color.getAWTColor()));
                }
            } else if (Objects.equals(declaringType, "Icons")) {
                Icon icon = FlutterMaterialIcons.getMaterialIconForName(name);
                return icon != null ? icon : EMPTY_ICON;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestion";
                break;
            }
        }
        objectArray2[1] = "io/flutter/editor/FlutterCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

