/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.editor;

import com.intellij.openapi.diagnostic.Logger;
import io.flutter.FlutterUtils;
import java.awt.Color;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterColors {
    private static final Logger LOG = Logger.getInstance(FlutterColors.class);
    private static final Properties colors = new Properties();

    @Nullable
    public static FlutterColor getColor(@NotNull String key) {
        Color color;
        if (key == null) {
            FlutterColors.$$$reportNull$$$0(0);
        }
        if (key.contains(".shade")) {
            key = key.replace(".shade", "[") + "]";
        }
        if (colors.containsKey(key)) {
            Color color2 = FlutterColors.getColorValue(key);
            if (color2 != null) {
                return new FlutterColor(color2, false);
            }
        } else if (colors.containsKey(key + ".primary") && (color = FlutterColors.getColorValue(key + ".primary")) != null) {
            return new FlutterColor(color, true);
        }
        return null;
    }

    private static Color getColorValue(String name) {
        try {
            String hexValue = colors.getProperty(name);
            if (hexValue == null) {
                return null;
            }
            long value = Long.parseLong(hexValue, 16);
            return new Color((int)(value >> 16) & 0xFF, (int)(value >> 8) & 0xFF, (int)value & 0xFF, (int)(value >> 24) & 0xFF);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static {
        try {
            colors.load(FlutterUtils.class.getResourceAsStream("/flutter/colors.properties"));
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "io/flutter/editor/FlutterColors", "getColor"));
    }

    public static class FlutterColor {
        @NotNull
        private final Color color;
        private final boolean isPrimary;

        private FlutterColor(@NotNull Color color, boolean isPrimary) {
            if (color == null) {
                FlutterColor.$$$reportNull$$$0(0);
            }
            this.color = color;
            this.isPrimary = isPrimary;
        }

        @NotNull
        public Color getAWTColor() {
            Color color = this.color;
            if (color == null) {
                FlutterColor.$$$reportNull$$$0(1);
            }
            return color;
        }

        public boolean isPrimary() {
            return this.isPrimary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "color";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "io/flutter/editor/FlutterColors$FlutterColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "io/flutter/editor/FlutterColors$FlutterColor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAWTColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

