/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import io.flutter.dart.DartPlugin;
import io.flutter.dart.FlutterOutlineListener;
import io.flutter.dart.FlutterRequestUtilities;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.dartlang.analysis.server.protocol.FlutterOutline;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDartAnalysisServer {
    private static final String FLUTTER_DESIGN_TIME_CONSTRUCTOR = "flutter.getChangeAddForDesignTimeConstructor";
    private static final String FLUTTER_NOTIFICATION_OUTLINE = "flutter.outline";
    @NotNull
    final DartAnalysisServerService analysisService;
    private final Map<String, List<String>> subscriptions;
    private final Map<String, List<FlutterOutlineListener>> fileOutlineListeners;
    private final Map<String, Consumer<JsonObject>> responseConsumers;

    @NotNull
    public static FlutterDartAnalysisServer getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(0);
        }
        FlutterDartAnalysisServer flutterDartAnalysisServer = (FlutterDartAnalysisServer)ServiceManager.getService((Project)project, FlutterDartAnalysisServer.class);
        if (flutterDartAnalysisServer == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(1);
        }
        return flutterDartAnalysisServer;
    }

    private FlutterDartAnalysisServer(@NotNull Project project) {
        if (project == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(2);
        }
        this.subscriptions = new HashMap<String, List<String>>();
        this.fileOutlineListeners = new HashMap<String, List<FlutterOutlineListener>>();
        this.responseConsumers = new HashMap<String, Consumer<JsonObject>>();
        this.analysisService = DartPlugin.getInstance().getAnalysisService(project);
        this.analysisService.addResponseListener(this::processResponse);
    }

    public void addOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        List listeners;
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(3);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(4);
        }
        if ((listeners = this.fileOutlineListeners.computeIfAbsent(filePath, k -> new ArrayList())).add(listener)) {
            this.addSubscription("OUTLINE", filePath);
        }
    }

    public void removeOutlineListener(@NotNull String filePath, @NotNull FlutterOutlineListener listener) {
        List<FlutterOutlineListener> listeners;
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(5);
        }
        if (listener == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(6);
        }
        if ((listeners = this.fileOutlineListeners.get(filePath)) != null && listeners.remove(listener)) {
            this.removeSubscription("OUTLINE", filePath);
        }
    }

    private void addSubscription(@NotNull String service, @NotNull String filePath) {
        List files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(7);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(8);
        }
        if ((files = this.subscriptions.computeIfAbsent(service, k -> new ArrayList())).add(filePath)) {
            this.sendSubscriptions();
        }
    }

    private void removeSubscription(@NotNull String service, @NotNull String filePath) {
        List<String> files;
        if (service == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(9);
        }
        if (filePath == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(10);
        }
        if ((files = this.subscriptions.get(service)) != null && files.remove(filePath)) {
            this.sendSubscriptions();
        }
    }

    private void sendSubscriptions() {
        String id = this.analysisService.generateUniqueId();
        this.analysisService.sendRequest(id, FlutterRequestUtilities.generateAnalysisSetSubscriptions(id, this.subscriptions));
    }

    @NotNull
    public List<SourceChange> edit_getAssists(@NotNull VirtualFile file, int offset, int length) {
        if (file == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(11);
        }
        List list = this.analysisService.edit_getAssists(file, offset, length);
        if (list == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public SourceChange flutter_getChangeAddForDesignTimeConstructor(@NotNull VirtualFile file, int _offset) {
        if (file == null) {
            FlutterDartAnalysisServer.$$$reportNull$$$0(13);
        }
        String filePath = FileUtil.toSystemDependentName((String)file.getPath());
        int offset = this.getOriginalOffset(file, _offset);
        CountDownLatch latch = new CountDownLatch(1);
        AtomicReference result = new AtomicReference();
        String id = this.analysisService.generateUniqueId();
        this.responseConsumers.put(id, (Consumer<JsonObject>)((Consumer)resultObject -> {
            try {
                JsonObject changeObject = resultObject.getAsJsonObject("change");
                SourceChange change = SourceChange.fromJson((JsonObject)changeObject);
                result.set(change);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            latch.countDown();
        }));
        JsonObject request = FlutterRequestUtilities.generateFlutterGetChangeAddForDesignTimeConstructor(id, filePath, offset);
        this.analysisService.sendRequest(id, request);
        Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        return (SourceChange)result.get();
    }

    private void processResponse(JsonObject response) {
        if (this.processNotification(response)) {
            return;
        }
        if (response.has("error")) {
            return;
        }
        JsonObject resultObject = response.getAsJsonObject("result");
        if (resultObject == null) {
            return;
        }
        JsonPrimitive idJsonPrimitive = (JsonPrimitive)response.get("id");
        if (idJsonPrimitive == null) {
            return;
        }
        String idString = idJsonPrimitive.getAsString();
        Consumer<JsonObject> consumer = this.responseConsumers.remove(idString);
        if (consumer == null) {
            return;
        }
        consumer.consume((Object)resultObject);
    }

    private boolean processNotification(JsonObject response) {
        JsonElement eventElement = response.get("event");
        if (eventElement == null || !eventElement.isJsonPrimitive()) {
            return false;
        }
        String event = eventElement.getAsString();
        if (event.equals(FLUTTER_NOTIFICATION_OUTLINE)) {
            JsonObject paramsObject = response.get("params").getAsJsonObject();
            String file = paramsObject.get("file").getAsString();
            JsonElement instrumentedCodeElement = paramsObject.get("instrumentedCode");
            String instrumentedCode = instrumentedCodeElement != null ? instrumentedCodeElement.getAsString() : null;
            JsonObject outlineObject = paramsObject.get("outline").getAsJsonObject();
            FlutterOutline outline = FlutterOutline.fromJson(outlineObject);
            List<FlutterOutlineListener> listeners = this.fileOutlineListeners.get(file);
            if (listeners != null) {
                for (FlutterOutlineListener listener : Lists.newArrayList(listeners)) {
                    listener.outlineUpdated(file, outline, instrumentedCode);
                }
            }
        }
        return true;
    }

    private int getOriginalOffset(@Nullable VirtualFile file, int convertedOffset) {
        Method method = ReflectionUtil.getDeclaredMethod(this.analysisService.getClass(), (String)"getOriginalOffset", (Class[])new Class[]{VirtualFile.class, Integer.TYPE});
        if (method != null) {
            try {
                return (Integer)method.invoke((Object)this.analysisService, file, convertedOffset);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return convertedOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/dart/FlutterDartAnalysisServer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "edit_getAssists";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addOutlineListener";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeOutlineListener";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSubscription";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeSubscription";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "edit_getAssists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "flutter_getChangeAddForDesignTimeConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

