/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.dart;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSyntax {
    @Nullable
    public static DartCallExpression findEnclosingFunctionCall(@NotNull PsiElement elt, @NotNull String functionName) {
        if (elt == null) {
            DartSyntax.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            DartSyntax.$$$reportNull$$$0(1);
        }
        while (elt != null) {
            DartCallExpression call;
            String name;
            if (elt instanceof DartCallExpression && (name = DartSyntax.getCalledFunctionName(call = (DartCallExpression)elt)) != null && name.equals(functionName)) {
                return call;
            }
            elt = elt.getParent();
        }
        return null;
    }

    @Nullable
    public static <E extends DartExpression> E getArgument(@NotNull DartCallExpression call, int index, @NotNull Class<E> expectedClass) {
        if (call == null) {
            DartSyntax.$$$reportNull$$$0(2);
        }
        if (expectedClass == null) {
            DartSyntax.$$$reportNull$$$0(3);
        }
        if (call.getArguments() == null) {
            return null;
        }
        DartArgumentList list = call.getArguments().getArgumentList();
        if (list == null) {
            return null;
        }
        List args = list.getExpressionList();
        if (args.size() <= index) {
            return null;
        }
        try {
            return (E)((DartExpression)expectedClass.cast(args.get(index)));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean isCallToFunctionNamed(@NotNull DartCallExpression element, @NotNull String function) {
        if (element == null) {
            DartSyntax.$$$reportNull$$$0(4);
        }
        if (function == null) {
            DartSyntax.$$$reportNull$$$0(5);
        }
        String name = DartSyntax.getCalledFunctionName(element);
        return Objects.equals(name, function);
    }

    public static boolean isMainFunctionDeclaration(@Nullable PsiElement element) {
        if (!(element instanceof DartFunctionDeclarationWithBodyOrNative)) {
            return false;
        }
        String functionName = ((DartFunctionDeclarationWithBodyOrNative)element).getComponentName().getId().getText();
        return Objects.equals(functionName, "main");
    }

    @Nullable
    public static String unquote(@NotNull DartStringLiteralExpression lit) {
        if (lit == null) {
            DartSyntax.$$$reportNull$$$0(6);
        }
        if (!lit.getShortTemplateEntryList().isEmpty() || !lit.getLongTemplateEntryList().isEmpty()) {
            return null;
        }
        if (lit.getFirstChild() == null) {
            return null;
        }
        PsiElement second = lit.getFirstChild().getNextSibling();
        if (second.getNextSibling() != lit.getLastChild()) {
            return null;
        }
        if (!(second instanceof LeafPsiElement)) {
            return null;
        }
        LeafPsiElement leaf = (LeafPsiElement)second;
        if (leaf.getElementType() != DartTokenTypes.REGULAR_STRING_PART) {
            return null;
        }
        return leaf.getText();
    }

    @Nullable
    private static String getCalledFunctionName(@NotNull DartCallExpression call) {
        if (call == null) {
            DartSyntax.$$$reportNull$$$0(7);
        }
        if (!(call.getFirstChild() instanceof DartReference)) {
            return null;
        }
        return call.getFirstChild().getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lit";
                break;
            }
        }
        objectArray2[1] = "io/flutter/dart/DartSyntax";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findEnclosingFunctionCall";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getArgument";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCallToFunctionNamed";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "unquote";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getCalledFunctionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

