/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.coverage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBusConnection;
import io.flutter.FlutterUtils;
import io.flutter.coverage.FlutterAppLiveCoverage;
import io.flutter.run.FlutterAppManager;
import io.flutter.run.daemon.FlutterApp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterLiveCoverageManager
implements Disposable {
    public static final boolean ENABLE_LIVE_COVERAGE = false;
    private FlutterAppLiveCoverage currentCoverage;
    private VirtualFile lastFile;
    private FileEditor lastEditor;

    public static void init(@NotNull Project project) {
        if (project == null) {
            FlutterLiveCoverageManager.$$$reportNull$$$0(0);
        }
        FlutterLiveCoverageManager.getInstance(project);
    }

    public static FlutterLiveCoverageManager getInstance(@NotNull Project project) {
        if (project == null) {
            FlutterLiveCoverageManager.$$$reportNull$$$0(1);
        }
        return (FlutterLiveCoverageManager)ServiceManager.getService((Project)project, FlutterLiveCoverageManager.class);
    }

    private FlutterLiveCoverageManager(@NotNull Project project) {
        if (project == null) {
            FlutterLiveCoverageManager.$$$reportNull$$$0(2);
        }
        Disposer.register((Disposable)project, (Disposable)this);
        FlutterAppManager.getInstance(project).getActiveAppAsStream().listen(this::updateCurrentAppChanged, true);
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor instanceof EditorEx) {
            this.lastFile = ((EditorEx)editor).getVirtualFile();
            if (this.couldContainCoverage(this.lastFile)) {
                this.lastEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor(this.lastFile);
                if (this.lastEditor == null) {
                    this.lastFile = null;
                }
            }
        }
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FlutterLiveCoverageManager.this.couldContainCoverage(event.getNewFile())) {
                    FlutterLiveCoverageManager.this.lastFile = event.getNewFile();
                    FlutterLiveCoverageManager.this.lastEditor = FlutterLiveCoverageManager.this.editorFor(event);
                } else {
                    FlutterLiveCoverageManager.this.lastFile = null;
                    FlutterLiveCoverageManager.this.lastEditor = null;
                }
                FlutterLiveCoverageManager.this.notifyCoverage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/coverage/FlutterLiveCoverageManager$1", "selectionChanged"));
            }
        });
    }

    private boolean couldContainCoverage(@Nullable VirtualFile file) {
        return file != null && FlutterUtils.isDartFile(file);
    }

    private FileEditor editorFor(FileEditorManagerEvent event) {
        if (!(event.getNewEditor() instanceof TextEditor)) {
            return null;
        }
        return event.getNewEditor();
    }

    private void updateCurrentAppChanged(@Nullable FlutterApp app) {
        if (app == null) {
            if (this.currentCoverage != null) {
                this.currentCoverage.dispose();
                this.currentCoverage = null;
            }
        } else if (this.currentCoverage != null && this.currentCoverage.getApp() != app) {
            this.currentCoverage.dispose();
        }
    }

    private void notifyCoverage() {
        if (this.currentCoverage == null) {
            return;
        }
        if (this.lastFile == null) {
            this.currentCoverage.showFor(null, null);
        } else {
            Module module = this.currentCoverage.getApp().getModule();
            if (module != null && ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)this.lastFile, (boolean)false)) {
                this.currentCoverage.showFor(this.lastFile, this.lastEditor);
            } else {
                this.currentCoverage.showFor(null, null);
            }
        }
    }

    public void dispose() {
        if (this.currentCoverage != null) {
            this.currentCoverage.dispose();
            this.currentCoverage = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "io/flutter/coverage/FlutterLiveCoverageManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

