/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.coverage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.EdtInvocationManager;
import io.flutter.coverage.EditorCoverageDecorations;
import io.flutter.coverage.ScriptManager;
import io.flutter.run.daemon.FlutterApp;
import io.flutter.utils.StreamSubscription;
import io.flutter.utils.VmServiceListenerAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dartlang.vm.service.VmService;
import org.dartlang.vm.service.VmServiceListener;
import org.dartlang.vm.service.consumer.ServiceExtensionConsumer;
import org.dartlang.vm.service.element.Event;
import org.dartlang.vm.service.element.EventKind;
import org.dartlang.vm.service.element.IsolateRef;
import org.dartlang.vm.service.element.RPCError;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.SourceReport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FlutterAppLiveCoverage
implements Disposable {
    @NotNull
    final FlutterApp app;
    @NotNull
    final FlutterApp.FlutterAppListener appListener;
    private StreamSubscription<IsolateRef> isolateRefStreamSubscription;
    private boolean isStarted;
    private boolean isDirty;
    private boolean isDisposed;
    private boolean requestInProgress;
    private ScriptManager scriptManager;
    private VmServiceListener vmServiceListener;
    private final Map<FileEditor, EditorCoverageDecorations> editorDecorations;
    @Nullable
    VirtualFile currentFile;
    @Nullable
    FileEditor currentEditor;

    FlutterAppLiveCoverage(final @NotNull FlutterApp app) {
        if (app == null) {
            FlutterAppLiveCoverage.$$$reportNull$$$0(0);
        }
        this.isDirty = true;
        this.isDisposed = false;
        this.requestInProgress = false;
        this.editorDecorations = new HashMap<FileEditor, EditorCoverageDecorations>();
        this.app = app;
        this.isStarted = app.isStarted();
        this.appListener = new FlutterApp.FlutterAppListener(){

            @Override
            public void stateChanged(FlutterApp.State newState) {
                if (!FlutterAppLiveCoverage.this.isStarted && app.isStarted()) {
                    FlutterAppLiveCoverage.this.isStarted = true;
                    FlutterAppLiveCoverage.this.requestRepaint(When.now);
                }
            }

            @Override
            public void notifyAppReloaded() {
                FlutterAppLiveCoverage.this.requestRepaint(When.now);
            }

            @Override
            public void notifyAppRestarted() {
                FlutterAppLiveCoverage.this.requestRepaint(When.now);
            }

            @Override
            public void notifyFrameRendered() {
                FlutterAppLiveCoverage.this.requestRepaint(When.soon);
            }

            @Override
            public void notifyVmServiceAvailable(VmService vmService) {
                FlutterAppLiveCoverage.this.setupConnection(vmService);
            }
        };
        app.addStateListener(this.appListener);
        if (app.getVmService() != null) {
            this.setupConnection(app.getVmService());
        }
    }

    @NotNull
    public FlutterApp getApp() {
        FlutterApp flutterApp = this.app;
        if (flutterApp == null) {
            FlutterAppLiveCoverage.$$$reportNull$$$0(1);
        }
        return flutterApp;
    }

    private boolean isConnected() {
        return this.scriptManager != null;
    }

    private IsolateRef getCurrentIsolateRef() {
        assert (this.app.getPerfService() != null);
        return this.app.getPerfService().getCurrentFlutterIsolateRaw();
    }

    private void setupConnection(@NotNull VmService vmService) {
        if (vmService == null) {
            FlutterAppLiveCoverage.$$$reportNull$$$0(2);
        }
        if (this.isDisposed) {
            return;
        }
        if (this.scriptManager != null) {
            return;
        }
        this.scriptManager = new ScriptManager(vmService);
        assert (this.app.getPerfService() != null);
        this.isolateRefStreamSubscription = this.app.getPerfService().getCurrentFlutterIsolate(isolateRef -> this.requestRepaint(When.soon), false);
        this.vmServiceListener = new VmServiceListenerAdapter(){

            @Override
            public void received(String streamId, Event event) {
                if (FlutterAppLiveCoverage.this.isDisposed) {
                    return;
                }
                EventKind kind = event.getKind();
                if (kind == EventKind.PauseBreakpoint || kind == EventKind.PauseException || kind == EventKind.PauseInterrupted) {
                    FlutterAppLiveCoverage.this.requestRepaint(When.soon);
                }
            }
        };
        vmService.addVmServiceListener(this.vmServiceListener);
        this.requestRepaint(When.soon);
    }

    private void requestRepaint(When when) {
        this.isDirty = true;
        if (this.requestInProgress) {
            return;
        }
        if (!this.isConnected() || this.currentFile == null || this.currentEditor == null) {
            return;
        }
        this.requestInProgress = true;
        FileEditor editor = this.currentEditor;
        VirtualFile file = this.currentFile;
        JobScheduler.getScheduler().schedule(() -> this.performRequest(editor, file), 0L, TimeUnit.SECONDS);
    }

    private void performRequest(final FileEditor fileEditor, final VirtualFile file) {
        assert (!EdtInvocationManager.getInstance().isEventDispatchThread());
        assert (this.app.getPerfService() != null);
        IsolateRef isolateRef = this.app.getPerfService().getCurrentFlutterIsolateRaw();
        VmService vmService = this.app.getVmService();
        assert (vmService != null);
        if (isolateRef == null) {
            this.requestInProgress = false;
            return;
        }
        this.isDirty = false;
        this.scriptManager.setCurrentIsolate(isolateRef);
        ScriptRef scriptRef = this.scriptManager.getScriptRefFor(file);
        if (scriptRef == null) {
            this.performRequestFinish();
            return;
        }
        JsonObject params = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add("Coverage");
        params.add("reports", (JsonElement)arr);
        params.addProperty("scriptId", scriptRef.getId());
        params.addProperty("forceCompile", Boolean.valueOf(true));
        vmService.callServiceExtension(isolateRef.getId(), "getSourceReport", params, new ServiceExtensionConsumer(){

            @Override
            public void received(JsonObject object) {
                JobScheduler.getScheduler().schedule(() -> {
                    SourceReport report = new SourceReport(object);
                    EditorCoverageDecorations editorDecoration = (EditorCoverageDecorations)FlutterAppLiveCoverage.this.editorDecorations.get(fileEditor);
                    editorDecoration.updateFromSourceReport(FlutterAppLiveCoverage.this.scriptManager, file, report);
                    FlutterAppLiveCoverage.this.performRequestFinish();
                }, 0L, TimeUnit.MILLISECONDS);
            }

            @Override
            public void onError(RPCError error) {
                FlutterAppLiveCoverage.this.performRequestFinish();
            }
        });
    }

    private void performRequestFinish() {
        this.requestInProgress = false;
        if (this.isDirty) {
            this.requestRepaint(When.soon);
        }
    }

    public void showFor(@Nullable VirtualFile file, @Nullable FileEditor fileEditor) {
        this.currentFile = file;
        this.currentEditor = fileEditor;
        this.harvestInvalidEditors();
        if (fileEditor != null) {
            if (!this.editorDecorations.containsKey(fileEditor)) {
                this.editorDecorations.put(fileEditor, new EditorCoverageDecorations(fileEditor));
            }
            this.requestRepaint(When.now);
        }
    }

    private void harvestInvalidEditors() {
        Iterator<FileEditor> editors = this.editorDecorations.keySet().iterator();
        while (editors.hasNext()) {
            FileEditor editor = editors.next();
            if (editor.isValid()) continue;
            EditorCoverageDecorations editorCoverageDecorations = this.editorDecorations.get(editor);
            editors.remove();
            editorCoverageDecorations.dispose();
        }
    }

    public void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        this.app.removeStateListener(this.appListener);
        this.scriptManager = null;
        for (EditorCoverageDecorations decorations : this.editorDecorations.values()) {
            decorations.dispose();
        }
        if (this.isolateRefStreamSubscription != null) {
            this.isolateRefStreamSubscription.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/coverage/FlutterAppLiveCoverage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vmService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/coverage/FlutterAppLiveCoverage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupConnection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum When {
        now,
        soon;

    }
}

