/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.coverage;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.TIntHashSet;

class FileCoverageInfo {
    private final VirtualFile file;
    private final TIntHashSet coveredLines = new TIntHashSet();
    private final TIntHashSet uncoveredLines = new TIntHashSet();

    public FileCoverageInfo(VirtualFile file) {
        this.file = file;
    }

    public VirtualFile getFile() {
        return this.file;
    }

    public void addCovered(Pair<Integer, Integer> pos) {
        if (pos == null) {
            return;
        }
        int line = (Integer)pos.first;
        this.coveredLines.add(line);
        this.uncoveredLines.remove(line);
    }

    public void addUncovered(int line) {
        if (!this.coveredLines.contains(line)) {
            this.uncoveredLines.add(line);
        }
    }

    public void addUncovered(Pair<Integer, Integer> pos) {
        if (pos == null) {
            return;
        }
        int line = (Integer)pos.first;
        if (!this.coveredLines.contains(line)) {
            this.uncoveredLines.add(line);
        }
    }

    public int[] getCoveredLines() {
        return this.coveredLines.toArray();
    }

    public int[] getUncoveredLines() {
        return this.uncoveredLines.toArray();
    }

    public boolean isCovered(int line) {
        return this.coveredLines.contains(line);
    }
}

