/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.coverage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import io.flutter.coverage.BlankLineMarkerRenderer;
import io.flutter.coverage.CoveredLineMarkerRenderer;
import io.flutter.coverage.FileCoverageInfo;
import io.flutter.coverage.FlutterLineMarkerRenderer;
import io.flutter.coverage.ScriptManager;
import io.flutter.coverage.UncoveredLineMarkerRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dartlang.vm.service.element.Script;
import org.dartlang.vm.service.element.ScriptRef;
import org.dartlang.vm.service.element.SourceReport;
import org.dartlang.vm.service.element.SourceReportCoverage;
import org.dartlang.vm.service.element.SourceReportRange;
import org.jetbrains.annotations.NotNull;

class EditorCoverageDecorations
implements Disposable {
    private static final VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
    private static final int HIGHLIGHTER_LAYER = 5999;
    @NotNull
    private final FileEditor fileEditor;
    private boolean hasDecorations;

    EditorCoverageDecorations(@NotNull FileEditor fileEditor) {
        if (fileEditor == null) {
            EditorCoverageDecorations.$$$reportNull$$$0(0);
        }
        this.hasDecorations = false;
        this.fileEditor = fileEditor;
        this.addBlankMarker();
    }

    private void addBlankMarker() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = ((TextEditor)this.fileEditor).getEditor();
            MarkupModel markupModel = editor.getMarkupModel();
            if (this.hasDecorations) {
                this.removeHighlightersFromEditor(markupModel);
            }
            if (editor.getDocument().getTextLength() > 0) {
                RangeHighlighter rangeHighlighter = markupModel.addLineHighlighter(0, 5999, new TextAttributes());
                rangeHighlighter.setLineMarkerRenderer((LineMarkerRenderer)new BlankLineMarkerRenderer());
                this.hasDecorations = true;
            }
        });
    }

    public void updateFromSourceReport(ScriptManager scriptManager, @NotNull VirtualFile reloadFile, @NotNull SourceReport report) {
        if (reloadFile == null) {
            EditorCoverageDecorations.$$$reportNull$$$0(1);
        }
        if (report == null) {
            EditorCoverageDecorations.$$$reportNull$$$0(2);
        }
        scriptManager.reset();
        ArrayList<ScriptRef> scripts = new ArrayList<ScriptRef>();
        for (ScriptRef scriptRef : report.getScripts()) {
            scripts.add(scriptRef);
        }
        FileCoverageInfo coverageInfo = new FileCoverageInfo(reloadFile);
        for (SourceReportRange reportRange : report.getRanges()) {
            VirtualFile file;
            ScriptRef scriptRef;
            String uri;
            SourceReportCoverage coverage = reportRange.getCoverage();
            if (coverage == null || coverage.getHits().isEmpty() || !(uri = (scriptRef = (ScriptRef)scripts.get(reportRange.getScriptIndex())).getUri()).startsWith("file:") || (file = virtualFileManager.findFileByUrl(uri)) == null || !file.equals(reloadFile)) continue;
            scriptManager.populateFor(scriptRef);
            Script script = scriptManager.getScriptFor(scriptRef);
            if (script == null) continue;
            for (List<Integer> encoded : script.getTokenPosTable()) {
                coverageInfo.addUncovered(encoded.get(0) - 1);
            }
            Iterator<Object> iterator = coverage.getHits().iterator();
            while (iterator.hasNext()) {
                int tokenPos = (Integer)iterator.next();
                coverageInfo.addCovered(scriptManager.getLineColumnPosForTokenPos(scriptRef, tokenPos));
            }
            iterator = coverage.getMisses().iterator();
            while (iterator.hasNext()) {
                int tokenPos = (Integer)iterator.next();
                coverageInfo.addUncovered(scriptManager.getLineColumnPosForTokenPos(scriptRef, tokenPos));
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            RangeHighlighter rangeHighlighter;
            UncoveredLineMarkerRenderer uncoveredRenderer = new UncoveredLineMarkerRenderer();
            TextAttributes coveredAttributes = new TextAttributes();
            TextAttributes uncoveredAttributes = new TextAttributes();
            assert (this.fileEditor instanceof TextEditor);
            Editor editor = ((TextEditor)this.fileEditor).getEditor();
            MarkupModel markupModel = editor.getMarkupModel();
            this.removeHighlightersFromEditor(markupModel);
            int markerCount = 0;
            for (int line : coverageInfo.getCoveredLines()) {
                rangeHighlighter = markupModel.addLineHighlighter(line, 5999, coveredAttributes);
                CoveredLineMarkerRenderer renderer = new CoveredLineMarkerRenderer(!coverageInfo.isCovered(line - 1), !coverageInfo.isCovered(line + 1));
                rangeHighlighter.setErrorStripeMarkColor(CoveredLineMarkerRenderer.coveredColor);
                rangeHighlighter.setThinErrorStripeMark(true);
                rangeHighlighter.setLineMarkerRenderer((LineMarkerRenderer)renderer);
                ++markerCount;
            }
            for (int line : coverageInfo.getUncoveredLines()) {
                rangeHighlighter = markupModel.addLineHighlighter(line, 5999, uncoveredAttributes);
                rangeHighlighter.setLineMarkerRenderer((LineMarkerRenderer)uncoveredRenderer);
                ++markerCount;
            }
            if (markerCount == 0) {
                RangeHighlighter rangeHighlighter2 = markupModel.addLineHighlighter(0, 5999, new TextAttributes());
                rangeHighlighter2.setLineMarkerRenderer((LineMarkerRenderer)new BlankLineMarkerRenderer());
            }
            this.hasDecorations = true;
        });
    }

    private void removeHighlightersFromEditor(MarkupModel markupModel) {
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            if (!(highlighter.getLineMarkerRenderer() instanceof FlutterLineMarkerRenderer)) continue;
            highlighters.add(highlighter);
        }
        for (RangeHighlighter highlighter : highlighters) {
            markupModel.removeHighlighter(highlighter);
        }
        this.hasDecorations = false;
    }

    public void flushDecorations() {
        if (this.hasDecorations && this.fileEditor.isValid()) {
            this.hasDecorations = false;
            ApplicationManager.getApplication().invokeLater(() -> {
                MarkupModel markupModel = ((TextEditor)this.fileEditor).getEditor().getMarkupModel();
                this.removeHighlightersFromEditor(markupModel);
            });
        }
    }

    public void dispose() {
        this.flushDecorations();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
        }
        objectArray2[1] = "io/flutter/coverage/EditorCoverageDecorations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFromSourceReport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

