/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.coverage;

import com.intellij.openapi.editor.Editor;
import com.intellij.ui.JBColor;
import io.flutter.coverage.FlutterLineMarkerRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

class CoveredLineMarkerRenderer
extends FlutterLineMarkerRenderer {
    static final Color coveredColor = new JBColor(new Color(37354), new Color(37354));
    private final boolean isStart;
    private final boolean isEnd;

    CoveredLineMarkerRenderer(boolean isStart, boolean isEnd) {
        this.isStart = isStart;
        this.isEnd = isEnd;
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        int width = r.width - 4;
        int height = r.height;
        g.setColor(coveredColor);
        if (!this.isStart && !this.isEnd) {
            g.fillRect(r.x + 2, r.y, width, height);
        } else {
            g.fillRoundRect(r.x + 2, r.y, width, height, 2, 2);
            int diff = height / 2;
            if (!this.isStart) {
                g.fillRect(r.x + 2, r.y, width, diff);
            }
            if (!this.isEnd) {
                g.fillRect(r.x + 2, r.y + diff, width, height - diff);
            }
        }
    }
}

