/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.console;

import com.intellij.execution.ConsoleFolding;
import com.intellij.openapi.util.text.StringUtil;
import io.flutter.sdk.FlutterSdkUtil;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterConsoleFolding
extends ConsoleFolding {
    private static final String flutterMarker = "/" + FlutterSdkUtil.flutterScriptName() + " --no-color ";
    private static final Pattern iosPattern = Pattern.compile("^\\w+: .* \\{$");
    private static final String iosCrashFormat1 = "\t        [";
    private static final String iosCrashFormat2 = "\t(";
    private static final String launchSequencePrefix = "CoreSimulatorBridge: Beginning launch sequence for bundle";
    private boolean isFolding = false;

    public boolean shouldFoldLine(@NotNull String line) {
        if (line == null) {
            FlutterConsoleFolding.$$$reportNull$$$0(0);
        }
        if (line.contains(flutterMarker)) {
            this.isFolding = false;
            return true;
        }
        if (iosPattern.matcher(line).matches() || line.startsWith(iosCrashFormat1) || line.startsWith(launchSequencePrefix)) {
            this.isFolding = true;
            return false;
        }
        if (line.equals(iosCrashFormat2)) {
            this.isFolding = true;
            return true;
        }
        if (this.isFolding && line.startsWith("\t")) {
            return true;
        }
        this.isFolding = false;
        return false;
    }

    @Nullable
    public String getPlaceholderText(@NotNull List<String> lines) {
        String fullText;
        int index;
        if (lines == null) {
            FlutterConsoleFolding.$$$reportNull$$$0(1);
        }
        if ((index = (fullText = StringUtil.join(lines, (String)"\n")).indexOf(flutterMarker)) == -1) {
            String trimmed = fullText.trim();
            if (trimmed.startsWith("(") && trimmed.endsWith(")")) {
                return " ( ... )";
            }
            if (lines.stream().anyMatch(s -> s.endsWith("}"))) {
                return " ... }";
            }
            return " ...";
        }
        return "flutter " + fullText.substring(index + flutterMarker.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        objectArray2[1] = "io/flutter/console/FlutterConsoleFolding";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldFoldLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPlaceholderText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

