/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import io.flutter.bazel.Workspace;
import io.flutter.project.ProjectWatch;
import io.flutter.utils.FileWatch;
import io.flutter.utils.Refreshable;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkspaceCache {
    @NotNull
    private final Project project;
    @NotNull
    private final Refreshable<Workspace> cache;
    private static final Logger LOG = Logger.getInstance(WorkspaceCache.class);

    private WorkspaceCache(@NotNull Project project) {
        if (project == null) {
            WorkspaceCache.$$$reportNull$$$0(0);
        }
        this.project = project;
        this.cache = new Refreshable();
        this.cache.setDisposeParent((Disposable)project);
        AtomicReference fileWatch = new AtomicReference();
        this.cache.subscribe(() -> {
            FileWatch prevWatch;
            if (project == null) {
                WorkspaceCache.$$$reportNull$$$0(3);
            }
            if (project.isDisposed()) {
                return;
            }
            Workspace next = this.cache.getNow();
            FileWatch nextWatch = null;
            if (next != null) {
                nextWatch = FileWatch.subscribe(next.getRoot(), next.getDependencies(), this::refreshAsync);
                nextWatch.setDisposeParent((Disposable)project);
            }
            if ((prevWatch = (FileWatch)fileWatch.getAndSet(nextWatch)) != null) {
                prevWatch.unsubscribe();
            }
        });
        ProjectWatch.subscribe(project, this::refreshAsync);
        this.refreshAsync();
    }

    @NotNull
    public static WorkspaceCache getInstance(@NotNull Project project) {
        if (project == null) {
            WorkspaceCache.$$$reportNull$$$0(1);
        }
        WorkspaceCache workspaceCache = (WorkspaceCache)ServiceManager.getService((Project)project, WorkspaceCache.class);
        if (workspaceCache == null) {
            WorkspaceCache.$$$reportNull$$$0(2);
        }
        return workspaceCache;
    }

    @Nullable
    public Workspace getNow() {
        return this.cache.getNow();
    }

    @Nullable
    public Workspace getWhenReady() {
        return this.cache.getWhenReady();
    }

    public void subscribe(Runnable callback) {
        this.cache.subscribe(callback);
    }

    public void unsubscribe(Runnable callback) {
        this.cache.unsubscribe(callback);
    }

    private void refreshAsync() {
        this.cache.refresh(() -> Workspace.load(this.project));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/bazel/WorkspaceCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/bazel/WorkspaceCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

