/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.bazel;

import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PluginConfig {
    @NotNull
    private final Fields fields;
    private static final Gson GSON = new Gson();
    private static final Logger LOG = Logger.getInstance(PluginConfig.class);

    private PluginConfig(@NotNull Fields fields) {
        if (fields == null) {
            PluginConfig.$$$reportNull$$$0(0);
        }
        this.fields = fields;
    }

    @Nullable
    String getDaemonScript() {
        return this.fields.daemonScript;
    }

    @Nullable
    String getDoctorScript() {
        return this.fields.doctorScript;
    }

    @Nullable
    String getLaunchScript() {
        return this.fields.launchScript;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginConfig)) {
            return false;
        }
        PluginConfig other = (PluginConfig)obj;
        return Objects.equal((Object)this.fields, (Object)other.fields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fields});
    }

    @Nullable
    public static PluginConfig load(@NotNull VirtualFile file) {
        if (file == null) {
            PluginConfig.$$$reportNull$$$0(1);
        }
        Computable readAction = () -> {
            if (file == null) {
                PluginConfig.$$$reportNull$$$0(2);
            }
            try {
                InputStreamReader input = new InputStreamReader(file.getInputStream(), "UTF-8");
                Fields fields = (Fields)GSON.fromJson((Reader)input, Fields.class);
                return new PluginConfig(fields);
            }
            catch (FileNotFoundException e) {
                LOG.info("Flutter plugin didn't find flutter.json at " + file.getPath());
                return null;
            }
            catch (IOException e) {
                LOG.warn("Flutter plugin failed to load config file at " + file.getPath(), (Throwable)e);
                return null;
            }
            catch (JsonSyntaxException e) {
                LOG.warn("Flutter plugin failed to parse JSON in config file at " + file.getPath());
                return null;
            }
            catch (PatternSyntaxException e) {
                LOG.warn("Flutter plugin failed to parse directory pattern (" + e.getPattern() + ") in config file at " + file.getPath());
                return null;
            }
        };
        return (PluginConfig)ApplicationManager.getApplication().runReadAction(readAction);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/bazel/PluginConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$load$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Fields {
        @SerializedName(value="daemonScript")
        private String daemonScript;
        @SerializedName(value="doctorScript")
        private String doctorScript;
        @SerializedName(value="launchScript")
        private String launchScript;

        Fields() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Fields)) {
                return false;
            }
            Fields other = (Fields)obj;
            return Objects.equal((Object)this.daemonScript, (Object)other.daemonScript) && Objects.equal((Object)this.doctorScript, (Object)other.doctorScript) && Objects.equal((Object)this.launchScript, (Object)other.launchScript);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.daemonScript, this.doctorScript, this.launchScript});
        }
    }
}

