/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import io.flutter.sdk.FlutterSdk;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntelliJAndroidSdk {
    private static final Logger LOG = Logger.getInstance(IntelliJAndroidSdk.class);
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final VirtualFile home;

    private IntelliJAndroidSdk(@NotNull Sdk sdk, @NotNull VirtualFile home) {
        if (sdk == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(0);
        }
        if (home == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(1);
        }
        this.sdk = sdk;
        this.home = home;
    }

    @NotNull
    public VirtualFile getHome() {
        VirtualFile virtualFile = this.home;
        if (virtualFile == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public void setCurrent(@NotNull Project project) {
        if (project == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(3);
        }
        assert (ApplicationManager.getApplication().isWriteAccessAllowed());
        ProjectRootManager roots = ProjectRootManager.getInstance((Project)project);
        roots.setProjectSdk(this.sdk);
    }

    @Nullable
    public static IntelliJAndroidSdk fromProject(@NotNull Project project) {
        if (project == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(4);
        }
        Sdk candidate = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        return IntelliJAndroidSdk.fromSdk(candidate);
    }

    @Nullable
    public static IntelliJAndroidSdk fromEnvironment() {
        String path = EnvironmentUtil.getValue((String)"ANDROID_HOME");
        if (path == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            return null;
        }
        return IntelliJAndroidSdk.fromHome(file);
    }

    @Nullable
    public static IntelliJAndroidSdk fromHome(VirtualFile file) {
        for (IntelliJAndroidSdk candidate : IntelliJAndroidSdk.findAll()) {
            if (!file.equals(candidate.getHome())) continue;
            return candidate;
        }
        return null;
    }

    public static String chooseAndroidHome(@Nullable Project project, boolean askFlutterTools) {
        String androidSdkLocation;
        FlutterSdk flutterSdk;
        if (project == null) {
            return EnvironmentUtil.getValue((String)"ANDROID_HOME");
        }
        IntelliJAndroidSdk intelliJAndroidSdk = IntelliJAndroidSdk.fromProject(project);
        if (intelliJAndroidSdk != null) {
            return intelliJAndroidSdk.getHome().getPath();
        }
        if (askFlutterTools && (flutterSdk = FlutterSdk.getFlutterSdk(project)) != null && (androidSdkLocation = flutterSdk.queryFlutterConfig("android-sdk", true)) != null) {
            return androidSdkLocation;
        }
        return EnvironmentUtil.getValue((String)"ANDROID_HOME");
    }

    @NotNull
    private static List<IntelliJAndroidSdk> findAll() {
        ArrayList<IntelliJAndroidSdk> result = new ArrayList<IntelliJAndroidSdk>();
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            IntelliJAndroidSdk candidate = IntelliJAndroidSdk.fromSdk(sdk);
            if (candidate == null) continue;
            result.add(candidate);
        }
        ArrayList<IntelliJAndroidSdk> arrayList = result;
        if (arrayList == null) {
            IntelliJAndroidSdk.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static IntelliJAndroidSdk fromSdk(@Nullable Sdk candidate) {
        if (candidate == null) {
            return null;
        }
        if (!"Android SDK".equals(candidate.getSdkType().getName())) {
            return null;
        }
        VirtualFile home = candidate.getHomeDirectory();
        if (home == null) {
            return null;
        }
        return new IntelliJAndroidSdk(candidate, home);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/android/IntelliJAndroidSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/android/IntelliJAndroidSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setCurrent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

