/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.android.AndroidEmulator;
import io.flutter.android.IntelliJAndroidSdk;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdk {
    private static final Logger LOG = Logger.getInstance(AndroidSdk.class);
    @NotNull
    private final VirtualFile home;

    @Nullable
    public static AndroidSdk createFromProject(@NotNull Project project) {
        String sdkPath;
        if (project == null) {
            AndroidSdk.$$$reportNull$$$0(0);
        }
        if ((sdkPath = IntelliJAndroidSdk.chooseAndroidHome(project, true)) == null) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(sdkPath);
        if (file == null) {
            return null;
        }
        return new AndroidSdk(file);
    }

    AndroidSdk(@NotNull VirtualFile home) {
        if (home == null) {
            AndroidSdk.$$$reportNull$$$0(1);
        }
        this.home = home;
    }

    @NotNull
    public VirtualFile getHome() {
        VirtualFile virtualFile = this.home;
        if (virtualFile == null) {
            AndroidSdk.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getEmulatorToolExecutable() {
        VirtualFile file = this.home.findFileByRelativePath("emulator/" + (SystemInfo.isWindows ? "emulator.exe" : "emulator"));
        if (file != null) {
            return file;
        }
        return this.home.findFileByRelativePath("tools/" + (SystemInfo.isWindows ? "emulator.exe" : "emulator"));
    }

    @NotNull
    public List<AndroidEmulator> getEmulators() {
        ArrayList<AndroidEmulator> arrayList;
        StringBuilder stringBuilder;
        block13: {
            OSProcessHandler process;
            block12: {
                VirtualFile emulator = this.getEmulatorToolExecutable();
                if (emulator == null) {
                    List<AndroidEmulator> list = Collections.emptyList();
                    if (list == null) {
                        AndroidSdk.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                String emulatorPath = emulator.getCanonicalPath();
                assert (emulatorPath != null);
                GeneralCommandLine cmd = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(this.home.getCanonicalPath()).withExePath(emulatorPath).withParameters(new String[]{"-list-avds"});
                stringBuilder = new StringBuilder();
                process = new OSProcessHandler(cmd);
                process.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void onTextAvailable(ProcessEvent event, Key outputType) {
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            stringBuilder.append(event.getText());
                        }
                    }
                });
                process.startNotify();
                if (process.waitFor(2000L)) break block12;
                List<AndroidEmulator> list = Collections.emptyList();
                if (list == null) {
                    AndroidSdk.$$$reportNull$$$0(4);
                }
                return list;
            }
            Integer exitCode = process.getExitCode();
            if (exitCode != null && process.getExitCode() == 0) break block13;
            List<AndroidEmulator> list = Collections.emptyList();
            if (list == null) {
                AndroidSdk.$$$reportNull$$$0(5);
            }
            return list;
        }
        try {
            ArrayList<AndroidEmulator> emulators = new ArrayList<AndroidEmulator>();
            for (String str : stringBuilder.toString().split("\n")) {
                if ((str = str.trim()).isEmpty()) continue;
                emulators.add(new AndroidEmulator(this, str));
            }
            arrayList = emulators;
        }
        catch (ExecutionException | RuntimeException e) {
            LOG.warn("Error listing android emulators", e);
            List<AndroidEmulator> list = Collections.emptyList();
            if (list == null) {
                AndroidSdk.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (arrayList == null) {
            AndroidSdk.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/android/AndroidSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/android/AndroidSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHome";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFromProject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

