/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.android;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterMessages;
import io.flutter.android.AndroidSdk;

public class AndroidEmulator {
    private static final Logger LOG = Logger.getInstance(AndroidEmulator.class);
    final AndroidSdk androidSdk;
    final String id;

    AndroidEmulator(AndroidSdk androidSdk, String id) {
        this.androidSdk = androidSdk;
        this.id = id;
    }

    public String getName() {
        return this.id.replaceAll("_", " ");
    }

    public void startEmulator() {
        VirtualFile emulator = this.androidSdk.getEmulatorToolExecutable();
        if (emulator == null) {
            FlutterMessages.showError("Error Opening Emulator", "Unable to locate the emulator tool in the Android SDK.");
            return;
        }
        String emulatorPath = emulator.getCanonicalPath();
        assert (emulatorPath != null);
        GeneralCommandLine cmd = new GeneralCommandLine().withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE).withWorkDirectory(this.androidSdk.getHome().getCanonicalPath()).withExePath(emulatorPath).withParameters(new String[]{"-avd", this.id});
        try {
            final StringBuilder stdout = new StringBuilder();
            OSProcessHandler process = new OSProcessHandler(cmd);
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    if (outputType == ProcessOutputTypes.STDERR || outputType == ProcessOutputTypes.STDOUT) {
                        stdout.append(event.getText());
                    }
                }

                public void processTerminated(ProcessEvent event) {
                    int exitCode = event.getExitCode();
                    if (exitCode != 0) {
                        String message = stdout.length() == 0 ? "Android emulator terminated with exit code " + exitCode : stdout.toString().trim();
                        FlutterMessages.showError("Error Opening Emulator", message);
                    }
                }
            });
            process.startNotify();
        }
        catch (ExecutionException | RuntimeException e) {
            FlutterMessages.showError("Error Opening Emulator", e.toString());
        }
    }
}

