/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import io.flutter.analytics.Analytics;
import org.jetbrains.annotations.NotNull;

public class ToolWindowTracker
extends ToolWindowManagerAdapter {
    private final Analytics myAnalytics;
    private final ToolWindowManagerEx myToolWindowManager;
    private String currentWindowId;

    public static void track(@NotNull Project project, @NotNull Analytics analytics) {
        if (project == null) {
            ToolWindowTracker.$$$reportNull$$$0(0);
        }
        if (analytics == null) {
            ToolWindowTracker.$$$reportNull$$$0(1);
        }
        new ToolWindowTracker(project, analytics);
    }

    private ToolWindowTracker(@NotNull Project project, @NotNull Analytics analytics) {
        if (project == null) {
            ToolWindowTracker.$$$reportNull$$$0(2);
        }
        if (analytics == null) {
            ToolWindowTracker.$$$reportNull$$$0(3);
        }
        this.myAnalytics = analytics;
        this.myToolWindowManager = ToolWindowManagerEx.getInstanceEx((Project)project);
        this.myToolWindowManager.addToolWindowManagerListener((ToolWindowManagerListener)this);
        this.update();
    }

    public void stateChanged() {
        this.update();
    }

    private void update() {
        String newWindow = this.findWindowId();
        if (!StringUtil.equals((CharSequence)newWindow, (CharSequence)this.currentWindowId)) {
            this.currentWindowId = newWindow;
            this.myAnalytics.sendScreenView(this.currentWindowId);
        }
    }

    @NotNull
    private String findWindowId() {
        String newWindow = this.myToolWindowManager.getActiveToolWindowId();
        String string = newWindow == null ? "editor" : newWindow.toLowerCase();
        if (string == null) {
            ToolWindowTracker.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analytics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "io/flutter/analytics/ToolWindowTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "io/flutter/analytics/ToolWindowTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findWindowId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "track";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

