/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.analytics;

public class ThrottlingBucket {
    private final int startingCount;
    private int drops;
    private long lastReplenish;

    public ThrottlingBucket(int startingCount) {
        this.startingCount = startingCount;
        this.drops = startingCount;
        this.lastReplenish = System.currentTimeMillis();
    }

    public boolean removeDrop() {
        this.checkReplenish();
        if (this.drops <= 0) {
            return false;
        }
        --this.drops;
        return true;
    }

    private void checkReplenish() {
        long now = System.currentTimeMillis();
        if (this.lastReplenish + 1000L >= now) {
            int inc = (int)(now - this.lastReplenish) / 1000;
            this.drops = Math.min(this.drops + inc, this.startingCount);
            this.lastReplenish += 1000L * (long)inc;
        }
    }
}

