/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.google.common.base.Joiner;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import io.flutter.FlutterBundle;
import io.flutter.FlutterInitializer;
import io.flutter.run.FlutterLaunchMode;
import io.flutter.run.LaunchState;
import io.flutter.run.SdkFields;
import io.flutter.run.SdkRunConfig;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunFlutterAction
extends AnAction {
    @NotNull
    private final String myDetailedTextKey;
    @NotNull
    private final FlutterLaunchMode myLaunchMode;
    @NotNull
    private final String myExecutorId;

    public RunFlutterAction(@NotNull String text, @NotNull String detailedTextKey, @NotNull String description, @NotNull Icon icon, @NotNull FlutterLaunchMode launchMode, @NotNull String executorId) {
        if (text == null) {
            RunFlutterAction.$$$reportNull$$$0(0);
        }
        if (detailedTextKey == null) {
            RunFlutterAction.$$$reportNull$$$0(1);
        }
        if (description == null) {
            RunFlutterAction.$$$reportNull$$$0(2);
        }
        if (icon == null) {
            RunFlutterAction.$$$reportNull$$$0(3);
        }
        if (launchMode == null) {
            RunFlutterAction.$$$reportNull$$$0(4);
        }
        if (executorId == null) {
            RunFlutterAction.$$$reportNull$$$0(5);
        }
        super(text, description, icon);
        this.myDetailedTextKey = detailedTextKey;
        this.myLaunchMode = launchMode;
        this.myExecutorId = executorId;
    }

    public void actionPerformed(AnActionEvent e) {
        Executor executor;
        FlutterInitializer.sendAnalyticsAction(this);
        RunnerAndConfigurationSettings settings = RunFlutterAction.getRunConfigSettings(e);
        if (settings == null) {
            return;
        }
        RunConfiguration configuration = settings.getConfiguration();
        if (!(configuration instanceof SdkRunConfig)) {
            return;
        }
        SdkRunConfig sdkRunConfig = (SdkRunConfig)configuration.clone();
        SdkFields fields = sdkRunConfig.getFields();
        String additionalArgs = fields.getAdditionalArgs();
        String flavorArg = null;
        if (fields.getBuildFlavor() != null) {
            flavorArg = "--flavor=" + fields.getBuildFlavor();
        }
        ArrayList<String> args = new ArrayList<String>();
        if (additionalArgs != null) {
            args.add(additionalArgs);
        }
        if (flavorArg != null) {
            args.add(flavorArg);
        }
        if (!args.isEmpty()) {
            fields.setAdditionalArgs(Joiner.on((String)" ").join(args));
        }
        if ((executor = RunFlutterAction.getExecutor(this.myExecutorId)) == null) {
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.create((Executor)executor, (RunConfiguration)sdkRunConfig);
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        FlutterLaunchMode.addToEnvironment(env, this.myLaunchMode);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    public void update(AnActionEvent e) {
        String config = RunFlutterAction.getSelectedRunConfig(e);
        String message = config != null ? FlutterBundle.message(this.myDetailedTextKey, config) : FlutterBundle.message("app.profile.action.text", new Object[0]);
        e.getPresentation().setText(message);
        e.getPresentation().setEnabled(RunFlutterAction.shouldEnable(e));
    }

    private static boolean shouldEnable(@Nullable AnActionEvent e) {
        RunnerAndConfigurationSettings settings = RunFlutterAction.getRunConfigSettings(e);
        RunConfiguration config = settings == null ? null : settings.getConfiguration();
        return config instanceof SdkRunConfig && LaunchState.getRunningAppProcess((SdkRunConfig)config) == null;
    }

    @Nullable
    protected static String getSelectedRunConfig(@Nullable AnActionEvent e) {
        RunConfiguration configuration;
        RunnerAndConfigurationSettings settings = RunFlutterAction.getRunConfigSettings(e);
        if (settings != null && (configuration = settings.getConfiguration()) != null) {
            return configuration.getName();
        }
        return null;
    }

    @Nullable
    private static RunnerAndConfigurationSettings getRunConfigSettings(@Nullable AnActionEvent event) {
        if (event == null) {
            return null;
        }
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        return RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
    }

    @Nullable
    private static Executor getExecutor(@NotNull String executorId) {
        if (executorId == null) {
            RunFlutterAction.$$$reportNull$$$0(6);
        }
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailedTextKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launchMode";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/RunFlutterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

