/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import io.flutter.FlutterBundle;
import io.flutter.FlutterMessages;
import io.flutter.actions.FlutterExternalIdeActionGroup;
import io.flutter.pub.PubRoot;
import io.flutter.pub.PubRoots;
import io.flutter.sdk.FlutterSdk;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInAndroidStudioAction
extends AnAction {
    private static final String LABEL_FILE = FlutterBundle.message("flutter.androidstudio.open.file.text", new Object[0]);
    private static final String DESCR_FILE = FlutterBundle.message("flutter.androidstudio.open.file.description", new Object[0]);
    private static final String LABEL_MODULE = FlutterBundle.message("flutter.androidstudio.open.module.text", new Object[0]);
    private static final String DESCR_MODULE = FlutterBundle.message("flutter.androidstudio.open.module.description", new Object[0]);

    public void update(AnActionEvent event) {
        OpenInAndroidStudioAction.updatePresentation(event, event.getPresentation());
    }

    public void actionPerformed(AnActionEvent e) {
        String androidStudioPath = OpenInAndroidStudioAction.findAndroidStudio(e.getProject());
        if (androidStudioPath == null) {
            FlutterMessages.showError("Error Opening Android Studio", "Unable to locate Android Studio.");
            return;
        }
        VirtualFile projectFile = OpenInAndroidStudioAction.findProjectFile(e);
        if (projectFile == null) {
            FlutterMessages.showError("Error Opening Android Studio", "Project not found.");
            return;
        }
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        String sourceFile = file == null ? null : (file.isDirectory() ? null : file.getPath());
        OpenInAndroidStudioAction.openFileInStudio(projectFile, androidStudioPath, sourceFile);
    }

    private static void updatePresentation(AnActionEvent event, Presentation state) {
        if (OpenInAndroidStudioAction.findProjectFile(event) == null) {
            state.setVisible(false);
        } else {
            String descr;
            String label;
            VirtualFile file = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
            if (file != null && !file.isDirectory()) {
                label = LABEL_FILE;
                descr = DESCR_FILE;
            } else {
                label = LABEL_MODULE;
                descr = DESCR_MODULE;
            }
            state.setVisible(true);
            state.setText(label);
            state.setDescription(descr);
        }
    }

    protected static boolean isProjectFileName(String name) {
        return name.endsWith("_android.iml");
    }

    protected static VirtualFile findProjectFile(@Nullable AnActionEvent e) {
        if (e != null) {
            Project project;
            VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(e.getDataContext());
            if (file != null && file.exists()) {
                project = e.getProject();
                assert (project != null);
                if (FlutterExternalIdeActionGroup.isWithinIOsDirectory(file, project)) {
                    return null;
                }
                VirtualFile projectDir = project.getBaseDir();
                for (PubRoot root : PubRoots.forProject(project)) {
                    if (!root.isFlutterPlugin()) continue;
                    VirtualFile rootFile = root.getRoot();
                    VirtualFile aFile = file;
                    while (aFile != null) {
                        if (aFile.equals(rootFile)) {
                            for (VirtualFile child : rootFile.getChildren()) {
                                if (!OpenInAndroidStudioAction.isExampleWithAndroidWithApp(child)) continue;
                                return child.findChild("android");
                            }
                        }
                        if (aFile.equals(projectDir)) {
                            aFile = null;
                            continue;
                        }
                        aFile = aFile.getParent();
                    }
                }
                if (OpenInAndroidStudioAction.isProjectFileName(file.getName())) {
                    return OpenInAndroidStudioAction.getProjectForFile(file);
                }
            }
            if ((project = e.getProject()) != null) {
                return OpenInAndroidStudioAction.getProjectForFile(OpenInAndroidStudioAction.findStudioProjectFile(project));
            }
        }
        return null;
    }

    private static void openFileInStudio(final @NotNull VirtualFile projectFile, @NotNull String androidStudioPath, @Nullable String sourceFile) {
        if (projectFile == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(0);
        }
        if (androidStudioPath == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(1);
        }
        try {
            GeneralCommandLine cmd;
            if (SystemInfo.isMac) {
                cmd = new GeneralCommandLine().withExePath("open").withParameters(new String[]{"-a", androidStudioPath, "--args", projectFile.getPath()});
                if (sourceFile != null) {
                    cmd.addParameter(sourceFile);
                }
            } else {
                cmd = new GeneralCommandLine().withExePath(androidStudioPath).withParameters(new String[]{projectFile.getPath()});
            }
            OSProcessHandler handler = new OSProcessHandler(cmd);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getExitCode() != 0) {
                        FlutterMessages.showError("Error Opening", projectFile.getPath());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "io/flutter/actions/OpenInAndroidStudioAction$1", "processTerminated"));
                }
            });
            handler.startNotify();
        }
        catch (ExecutionException ex) {
            FlutterMessages.showError("Error Opening", "Exception: " + ex.getMessage());
        }
    }

    @Nullable
    private static VirtualFile findStudioProjectFile(@NotNull Project project) {
        if (project == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(2);
        }
        for (PubRoot root : PubRoots.forProject(project)) {
            for (VirtualFile child : root.getRoot().getChildren()) {
                if (!OpenInAndroidStudioAction.isProjectFileName(child.getName())) continue;
                return child;
            }
        }
        return null;
    }

    @Nullable
    private static String findAndroidStudio(@Nullable Project project) {
        String androidSdkLocation;
        if (project == null) {
            return null;
        }
        FlutterSdk flutterSdk = FlutterSdk.getFlutterSdk(project);
        if (flutterSdk != null && (androidSdkLocation = flutterSdk.queryFlutterConfig("android-studio-dir", true)) != null) {
            if (androidSdkLocation.contains("/Android Studio 2")) {
                Messages.showErrorDialog((String)FlutterBundle.message("old.android.studio.message", File.separator), (String)FlutterBundle.message("old.android.studio.title", new Object[0]));
                return null;
            }
            if (androidSdkLocation.endsWith("/")) {
                androidSdkLocation = androidSdkLocation.substring(0, androidSdkLocation.length() - 1);
            }
            String contents = "/Contents";
            if (SystemInfo.isMac && androidSdkLocation.endsWith("/Contents")) {
                return androidSdkLocation.substring(0, androidSdkLocation.length() - "/Contents".length());
            }
            return androidSdkLocation;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getProjectForFile(@Nullable VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            return OpenInAndroidStudioAction.isAndroidWithApp(file) ? file : null;
        }
        VirtualFile dir = file.getParent();
        if (OpenInAndroidStudioAction.isAndroidWithApp(dir)) {
            return dir;
        }
        VirtualFile project = dir.findChild("android");
        if (project != null && OpenInAndroidStudioAction.isAndroidWithApp(project)) {
            return project;
        }
        return null;
    }

    private static boolean isAndroidWithApp(@NotNull VirtualFile file) {
        if (file == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(3);
        }
        return file.getName().equals("android") && (file.findChild("app") != null || file.findChild("src") != null);
    }

    private static boolean isExampleWithAndroidWithApp(@NotNull VirtualFile file) {
        if (file == null) {
            OpenInAndroidStudioAction.$$$reportNull$$$0(4);
        }
        boolean hasPubspec = false;
        boolean hasAndroid = false;
        for (VirtualFile candidate : file.getChildren()) {
            if (OpenInAndroidStudioAction.isAndroidWithApp(candidate)) {
                hasAndroid = true;
            }
            if (candidate.getName().equals("pubspec.yaml")) {
                hasPubspec = true;
            }
            if (!hasAndroid || !hasPubspec) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidStudioPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/OpenInAndroidStudioAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openFileInStudio";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findStudioProjectFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAndroidWithApp";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isExampleWithAndroidWithApp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

