/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import io.flutter.actions.FlutterSdkAction;
import io.flutter.bazel.Workspace;
import io.flutter.console.FlutterConsoles;
import io.flutter.pub.PubRoot;
import io.flutter.sdk.FlutterSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlutterDoctorAction
extends FlutterSdkAction {
    private static final Logger LOG = Logger.getInstance(FlutterDoctorAction.class);

    @Override
    public void startCommand(@NotNull Project project, @NotNull FlutterSdk sdk, @Nullable PubRoot root) {
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(0);
        }
        if (sdk == null) {
            FlutterDoctorAction.$$$reportNull$$$0(1);
        }
        sdk.flutterDoctor().startInConsole(project);
    }

    @Override
    public void startCommandInBazelContext(@NotNull Project project, @NotNull Workspace workspace) {
        String doctorScript;
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(2);
        }
        if (workspace == null) {
            FlutterDoctorAction.$$$reportNull$$$0(3);
        }
        if ((doctorScript = workspace.getDoctorScript()) != null) {
            this.runWorkspaceFlutterDoctorScript(project, workspace.getRoot().getPath(), doctorScript);
        } else {
            LOG.error("No \"doctorScript\" script in the flutter.json file.");
        }
    }

    private void runWorkspaceFlutterDoctorScript(@NotNull Project project, @NotNull String workDir, @NotNull String doctorScript) {
        if (project == null) {
            FlutterDoctorAction.$$$reportNull$$$0(4);
        }
        if (workDir == null) {
            FlutterDoctorAction.$$$reportNull$$$0(5);
        }
        if (doctorScript == null) {
            FlutterDoctorAction.$$$reportNull$$$0(6);
        }
        GeneralCommandLine cmdLine = new GeneralCommandLine().withWorkDirectory(workDir);
        cmdLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        cmdLine.setExePath(FileUtil.toSystemDependentName((String)doctorScript));
        try {
            OSProcessHandler handler = new OSProcessHandler(cmdLine);
            FlutterConsoles.displayProcessLater(handler, project, null, () -> ((OSProcessHandler)handler).startNotify());
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public boolean enableActionInBazelContext() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doctorScript";
                break;
            }
        }
        objectArray2[1] = "io/flutter/actions/FlutterDoctorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommand";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "startCommandInBazelContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "runWorkspaceFlutterDoctorScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

